/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUSFILEDESCRIPTOR_H
#define CONEXUSFILEDESCRIPTOR_H

#include <conexus/io.h>

namespace conexus {

/**
 * This class is the top level object for all subclasses performing I/O (Input/Output)
 * operations via file descriptors (which in Linux/Unix/POSIX can be used for almost all
 * I/O).
 *
 * @author Rick L Vinyard Jr
 */
class FileDescriptor : public IO
{
public:
  FileDescriptor(int fd=-1, bool close_on_destruction=true);

    ~FileDescriptor();

    /**
     * Base class method returning the raw file descriptor.
     *
     * This class is also available as the "fd" property.
     */
    virtual int get_fd() throw ();

    /**
     * Closes the IO object by closing the member file descriptor.
     *
     * If the object is already closed will return without attempting to close.
     */
    virtual void close() throw (close_error);


  /**
   * Sets the responsiveness to add_*, remove_* and stop commands in microseconds;
   * lower is more responsive; larger is less responsive; default is 5000 microseconds (or 5 ms).
   *
   * In general this refers to the timeout period of the @em select() call used internally.
   * Each cycle of the server I/O thread acquires several mutex locks at the beginning
   * of the cycle and releases them at the end of the cycle.
   *
   * This value shortens the cycle period, thereby making the server more responsive to commands at
   * the cost of increasing overhead.
   */
  void set_responsiveness(long r);

  /**
   * Returns the server responsiveness level.
   */
  long get_responsiveness();


  protected:
    int m_fd;
    struct timeval m_timeval;

    virtual void service_thread_main();

};

}

#endif
