/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "ip_ip.h"

using namespace conexus::IP;

IP::IP(int type, int protocol)
 : Socket(PF_INET, type, protocol),
m_remote_address_set(false)
{
}


IP::~IP() throw ()
{
}

void IP::bind() throw(bind_error) {
  Socket::bind(m_local_address);
}

void IP::set_interface(const std::string addr) {
  m_local_address.set_hostname(addr);
}

void IP::set_local_port(u_int16_t port) {
  m_local_address.set_port(port);
}

void IP::set_remote_port(u_int16_t port) {
  m_remote_address.set_port(port);
}

const Address & IP::get_local_address( )
{
  return m_local_address;
}

const Address & IP::get_remote_address( )
{
  return m_remote_address;
}

void IP::set_remote_address( Address addr )
{
  m_remote_address = addr;
  m_remote_address_set = true;
}

void IP::set_local_address( Address addr )
{
  m_local_address = addr;
}
