/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "ip_multicast.h"

using namespace conexus::IP;

Multicast::Multicast()
  : UDP()
{
}


Multicast::~Multicast() throw()
{
}

void Multicast::join(Address& addr, int ifindex) {
  struct ip_mreqn mreq;
  mreq.imr_multiaddr = addr.get_sockaddr_in().sin_addr;
  mreq.imr_address = m_local_address.get_sockaddr_in().sin_addr;
  mreq.imr_ifindex = ifindex;
  set_option(SOL_IP, IP_ADD_MEMBERSHIP, mreq);
}

void Multicast::join(const std::string addr, int ifindex) {
  Address a;
  a.set_hostname(addr);
  join(a, ifindex);
}

void Multicast::leave(Address& addr, int ifindex) {
  struct ip_mreqn mreq;
  mreq.imr_multiaddr = addr.get_sockaddr_in().sin_addr;
  mreq.imr_address = m_local_address.get_sockaddr_in().sin_addr;
  mreq.imr_ifindex = ifindex;
  set_option(SOL_IP, IP_DROP_MEMBERSHIP, mreq);
}

void Multicast::leave(const std::string addr, int ifindex) {
  Address a;
  a.set_hostname(addr);
  leave(a, ifindex);
}

int Multicast::get_multicast_ttl() {
  int i;
  get_option(SOL_IP, IP_MULTICAST_TTL, i);
  return i;
}

void Multicast::set_multicast_ttl(int i) {
  set_option(SOL_IP, IP_MULTICAST_TTL, i);
}

bool Multicast::get_multicast_loop() {
  int i;
  get_option(SOL_IP, IP_MULTICAST_LOOP, i);
  return i;
}

void Multicast::set_multicast_loop(bool b) {
  int i = b?1:0;
  set_option(SOL_IP, IP_MULTICAST_LOOP, i);
}

