/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "utility.h"

#include <netinet/in.h>
#include <sys/ioctl.h>
#include <net/if.h>

#include <netpacket/packet.h>
#include <net/ethernet.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <glibmm/thread.h>

using namespace conexus;

int conexus::get_interface_index(const std::string name) {
  int sd = socket(PF_PACKET, SOCK_RAW, 0);
  int ifindex = -1;
  struct ifreq req;
  strncpy(req.ifr_name, name.c_str(), IFNAMSIZ);
  if (ioctl(sd, SIOCGIFINDEX, &req) >= 0)
    ifindex = req.ifr_ifindex;
  close(sd);
  return ifindex;
}

std::string conexus::get_interface_name(int ifindex) {
  int sd = socket(PF_PACKET, SOCK_RAW, 0);
  struct ifreq req;
  std::string ifname;
  req.ifr_ifindex = ifindex;
  if (ioctl(sd, SIOCGIFNAME, &req) >= 0)
    ifname = req.ifr_name;
  close(sd);
  return ifname;
}


#define MAX_REQ_SIZE 100

std::vector<std::string> conexus::get_interface_names() {
  int sd = socket(PF_PACKET, SOCK_RAW, 0);
  struct ifreq* req;
  struct ifconf conf;
  char buf[sizeof(struct ifreq)*MAX_REQ_SIZE];
  std::vector<std::string> ifnames;

  conf.ifc_len = sizeof(buf);
  conf.ifc_buf = (caddr_t)buf;

  if (ioctl(sd, SIOCGIFCONF, (caddr_t)&conf) >= 0)
    for (req = (struct ifreq*)conf.ifc_buf; (caddr_t)req < conf.ifc_buf+conf.ifc_len; req++)
      ifnames.push_back(std::string(req->ifr_name));

  close(sd);
  return ifnames;
}

std::vector< std::pair < std::string , std::string > > conexus::get_interface_ip_addresses( )
{
  std::vector< std::pair<std::string, std::string> > ifaddrs;

  int sd = socket(PF_PACKET, SOCK_RAW, 0);
  struct ifreq* req;
  struct ifconf conf;
  char buf[sizeof(struct ifreq)*MAX_REQ_SIZE];
  std::pair<std::string, std::string> interface;
  struct sockaddr_in* sa;

  conf.ifc_len = sizeof(buf);
  conf.ifc_buf = (caddr_t)buf;

  if (ioctl(sd, SIOCGIFCONF, (caddr_t)&conf) >= 0)
    for (req = (struct ifreq*)conf.ifc_buf; (caddr_t)req < conf.ifc_buf+conf.ifc_len; req++) {
      interface.first = std::string(req->ifr_name);
      if (req->ifr_addr.sa_family == AF_INET) {
        sa = (struct sockaddr_in*)&(req->ifr_addr);
        interface.second = std::string(inet_ntoa(sa->sin_addr));
        ifaddrs.push_back(interface);
      }
    }

  close(sd);
  return ifaddrs;
}

void conexus::init() {
  if(!Glib::thread_supported()) Glib::thread_init();
}
