/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "hostentry.h"

#include <netdb.h>

using namespace conexusgtk::IP;

HostEntry::HostEntry()
  : Gtk::VBox(), m_change_lock(false)
{
  setup_widget();
}

HostEntry::HostEntry( conexus::IP::Address & addr )
{
  setup_widget();
  std::string hn = addr.get_hostname();
  if (hn.size() > 0) {
    m_host.prepend_text(hn);
    m_host_names.insert(hn);
    m_host.set_active_text(hn);
  }
  connect(addr);
}


HostEntry::~HostEntry()
{
}

void HostEntry::on_host_changed( )
{
  struct hostent *h;
  h = gethostbyname( get_host().c_str() );

  if (h == NULL) {
    if (m_image_holder.get_child() != &m_bad_host_image) {
      m_image_holder.remove();
      m_image_holder.add(m_bad_host_image);
      m_hostname_label.set_markup("<small><i>Invalid Entry</i></small>");
      m_address_label.set_markup("<small><i>Invalid Entry</i></small>");
      m_signal_host_changed.emit(false);
    }
  }
  else {
    if (m_image_holder.get_child() != &m_good_host_image) {
    m_image_holder.remove();
    m_image_holder.add(m_good_host_image);
    m_image_holder.show_all_children();
    }
    if (m_host_names.find(get_host()) == m_host_names.end()) {
      m_host.prepend_text(get_host());
      m_host_names.insert(get_host());
    }
    m_hostname_label.set_markup(h->h_name);
    m_address_label.set_markup(h->h_addr_list[0]);

    conexus::IP::Address addr;
    for (Addresses::iterator i = m_connected_addresses.begin(); i != m_connected_addresses.end(); i++)
      (*i)->set_hostname(get_host());
    for (IPSockets::iterator i = m_connected_local_ipsockets.begin(); i != m_connected_local_ipsockets.end(); i++) {
      addr = (*i)->get_local_address();
      addr.set_hostname(get_host());
      (*i)->set_local_address(addr);
    }
    for (IPSockets::iterator i = m_connected_remote_ipsockets.begin(); i != m_connected_remote_ipsockets.end(); i++) {
      addr = (*i)->get_remote_address();
      addr.set_hostname(get_host());
      (*i)->set_remote_address(addr);
    }
    m_signal_host_changed.emit(true);
}
}

Gtk::ComboBoxEntryText& HostEntry::get_host_box( )
{
  return m_host;
}

std::string HostEntry::get_host( )
{
  return m_host.get_entry()->get_text();
}

sigc::signal< void, bool > HostEntry::signal_host_changed( )
{
  return m_signal_host_changed;
}

Gtk::Image & HostEntry::get_good_host_image( )
{
  return m_good_host_image;
}

Gtk::Image & HostEntry::get_bad_host_image( )
{
  return m_bad_host_image;
}

void HostEntry::connect( conexus::IP::Address & address )
{
  m_connected_addresses.insert(&address);
  address.set_hostname(get_host());
}

void HostEntry::disconnect( conexus::IP::Address & address )
{
  m_connected_addresses.erase(&address);
}

void HostEntry::connect_local_address( conexus::IP::IP & ip )
{
  conexus::IP::Address addr;
  m_connected_local_ipsockets.insert(&ip);
  addr = ip.get_local_address();
  addr.set_hostname(get_host());
  ip.set_local_address(addr);
}

void HostEntry::disconnect_local_address( conexus::IP::IP & ip )
{
  m_connected_local_ipsockets.erase(&ip);
}

void HostEntry::connect_remote_address( conexus::IP::IP & ip )
{
  conexus::IP::Address addr;
  m_connected_remote_ipsockets.insert(&ip);
  addr = ip.get_remote_address();
  addr.set_hostname(get_host());
  ip.set_remote_address(addr);
}

void HostEntry::disconnect_remote_address( conexus::IP::IP & ip )
{
  m_connected_remote_ipsockets.erase(&ip);
}

void HostEntry::setup_widget( )
{
  set_homogeneous(false);

  Gtk::HBox* hbox = Gtk::manage(new Gtk::HBox());
  hbox->set_homogeneous(false);

  hbox->pack_start(m_host);
  hbox->pack_start(m_image_holder, Gtk::PACK_SHRINK);

  m_host.signal_changed().connect(sigc::mem_fun(*this, &HostEntry::on_host_changed));

  m_good_host_image.set_from_icon_name("stock_internet", Gtk::IconSize(Gtk::ICON_SIZE_LARGE_TOOLBAR));
  m_bad_host_image.set_from_icon_name("gtk-dialog-error", Gtk::IconSize(Gtk::ICON_SIZE_LARGE_TOOLBAR));
  m_image_holder.add(m_bad_host_image);

  pack_start(*hbox);

  m_hostname_label.set_markup("<small><i>Invalid Entry</i></small>");
  m_address_label.set_markup("<small><i>Invalid Entry</i></small>");
  m_hostname_label.set_use_markup(true);
  m_address_label.set_use_markup(true);

//   pack_start(m_hostname_label);
//   pack_start(m_address_label);

  show_all_children();
}

std::string HostEntry::set_host( std::string s )
{
  m_host.prepend_text(s);
  m_host_names.insert(s);
  m_host.set_active_text(s);
}



