/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "hostportentry.h"

using namespace conexusgtk::IP;

HostPortEntry::HostPortEntry()
 : Gtk::Table()
{
  attach(m_host, 0, 1, 0, 1);
  attach(m_port, 0, 1, 1, 2);
}

HostPortEntry::~HostPortEntry()
{
}

HostEntry & HostPortEntry::get_host_entry( )
{
  return m_host;
}

PortEntry & HostPortEntry::get_port_entry( )
{
  return m_port;
}

void HostPortEntry::connect( conexus::IP::Address & address )
{
  m_host.connect(address);
  m_port.connect(address);
}

void HostPortEntry::disconnect( conexus::IP::Address & address )
{
  m_host.disconnect(address);
  m_port.disconnect(address);
}

void HostPortEntry::connect_local_address( conexus::IP::IP & ip )
{
  m_host.connect_local_address(ip);
  m_port.connect_local_port(ip);
}

void HostPortEntry::disconnect_local_address( conexus::IP::IP & ip )
{
  m_host.disconnect_local_address(ip);
  m_port.disconnect_local_port(ip);
}

void HostPortEntry::connect_remote_address( conexus::IP::IP & ip )
{
  m_host.connect_remote_address(ip);
  m_port.connect_remote_port(ip);
}

void HostPortEntry::disconnect_remote_address( conexus::IP::IP & ip )
{
  m_host.disconnect_remote_address(ip);
  m_port.disconnect_remote_port(ip);
}

sigc::signal< void, bool > HostPortEntry::signal_host_changed( )
{
  return m_host.signal_host_changed();
}

sigc::signal< void > HostPortEntry::signal_port_changed( )
{
  return m_port.signal_port_changed();
}

std::string HostPortEntry::get_host( )
{
  return m_host.get_host();
}

void HostPortEntry::set_host( std::string s)
{
  m_host.set_host(s);
}

uint32_t HostPortEntry::get_port( )
{
  return m_port.get_port();
}

void HostPortEntry::set_port( uint32_t p )
{
  m_port.set_port(p);
}
