/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "ioblockbutton.h"

using namespace conexusgtk;

IOBlockButton::IOBlockButton()
 : Gtk::HBox()
{
  set_spacing(5);
  pack_start(m_button, Gtk::PACK_SHRINK);
  pack_start(m_image, Gtk::PACK_SHRINK);
  pack_start(m_text, Gtk::PACK_SHRINK);
  change_display(false);
  m_button.signal_toggled().connect(sigc::mem_fun(*this, &IOBlockButton::on_button_toggled));
}


IOBlockButton::~IOBlockButton()
{
}

void IOBlockButton::on_button_toggled( )
{
  bool active = m_button.get_active();
  change_display(active);
    Controlled::iterator i;
    for (i = m_read_control.begin(); i != m_read_control.end(); i++)
      (*i)->block_read(!active);
    for (i = m_write_control.begin(); i != m_write_control.end(); i++)
      (*i)->block_write(!active);
}

void IOBlockButton::change_display(bool b)
{
  if (b) {
    m_image.set_from_icon_name("stock_connect", Gtk::IconSize(Gtk::ICON_SIZE_LARGE_TOOLBAR));
    m_text.set_markup("Connected  <i><small>( Click to Disconnect )</small></i>");
    m_text.set_use_markup();
  }
  else {
    m_image.set_from_icon_name("stock_disconnect", Gtk::IconSize(Gtk::ICON_SIZE_LARGE_TOOLBAR));
    m_text.set_markup("Disconnected  <i><small>( Click to Connect )</small></i>");
    m_text.set_use_markup();
  }
}

void conexusgtk::IOBlockButton::connect( conexus::IO & io, bool control_read, bool control_write )
{
  bool active = m_button.get_active();
  if (control_read) {
    m_read_control.insert(&io);
    io.block_read(!active);
  }
  else
    m_read_control.erase(&io);

  if (control_write) {
    m_write_control.insert(&io);
    io.block_write(!active);
  }
  else
    m_write_control.erase(&io);
}

void conexusgtk::IOBlockButton::disconnect( conexus::IO & io )
{
  m_read_control.erase(&io);
  m_write_control.erase(&io);
}

