/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "portentry.h"

#include <sstream>

using namespace conexusgtk::IP;

#define DEFAULT_PORT 1
#define MIN_PORT 0
#define MAX_PORT 32767
#define PORT_INC 1
#define PORT_PAGE_INC 100

PortEntry::PortEntry()
 : Gtk::VBox(),
 m_port_adjustment(DEFAULT_PORT, MIN_PORT, MAX_PORT, PORT_INC, PORT_PAGE_INC)
{
  setup_widget();
}

PortEntry::PortEntry( conexus::IP::Address & addr )
  : Gtk::VBox(),
 m_port_adjustment(DEFAULT_PORT, MIN_PORT, MAX_PORT, PORT_INC, PORT_PAGE_INC)
{
  setup_widget();
  m_port.set_value(addr.get_port());
  connect(addr);
}

PortEntry::~PortEntry()
{
}

Gtk::SpinButton & PortEntry::get_port_button( )
{
  return m_port;
}

Gtk::Adjustment & PortEntry::get_port_adjustment( )
{
  return m_port_adjustment;
}

void PortEntry::connect( conexus::IP::Address & address )
{
  m_connected_addresses.insert(&address);
  address.set_port(get_port());
}

void PortEntry::disconnect( conexus::IP::Address & address )
{
  m_connected_addresses.erase(&address);
}

void PortEntry::connect_local_port( conexus::IP::IP & ip )
{
  m_connected_local_ipsockets.insert(&ip);
  ip.set_local_port(get_port());
}

void PortEntry::disconnect_local_port( conexus::IP::IP & ip )
{
  m_connected_local_ipsockets.erase(&ip);
}

void PortEntry::connect_remote_port( conexus::IP::IP & ip )
{
  m_connected_remote_ipsockets.insert(&ip);
  ip.set_remote_port(get_port());
}

void PortEntry::disconnect_remote_port( conexus::IP::IP & ip )
{
  m_connected_remote_ipsockets.erase(&ip);
}

void PortEntry::on_port_changed( )
{
  uint32_t port = get_port();
  for (Addresses::iterator i = m_connected_addresses.begin(); i != m_connected_addresses.end(); i++)
    (*i)->set_port(port);
  for (IPSockets::iterator i = m_connected_local_ipsockets.begin(); i != m_connected_local_ipsockets.end(); i++)
    (*i)->set_local_port(port);
  for (IPSockets::iterator i = m_connected_remote_ipsockets.begin(); i != m_connected_remote_ipsockets.end(); i++)
    (*i)->set_remote_port(port);
  m_signal_port_changed.emit();
}

void PortEntry::setup_widget( )
{
  set_homogeneous(false);

  Gtk::HBox* hbox = Gtk::manage(new Gtk::HBox());
  hbox->set_homogeneous(false);

  hbox->pack_start(m_port);
  m_port.configure(m_port_adjustment, 0.5, 0);

  m_port.signal_changed().connect(sigc::mem_fun(*this, &PortEntry::on_port_changed));
  m_port.signal_insert_text().connect(sigc::mem_fun(*this, &PortEntry::on_spinbutton_text_entry));
  m_port.signal_delete_text().connect(sigc::mem_fun(*this, &PortEntry::on_spinbutton_text_delete));

  pack_start(*hbox);
}

sigc::signal< void > conexusgtk::IP::PortEntry::signal_port_changed( )
{
  return m_signal_port_changed;
}

uint32_t PortEntry::get_port( )
{
  return m_port.get_value_as_int();
}

void conexusgtk::IP::PortEntry::set_port( uint32_t p )
{
  m_port.set_value(p);
}

void conexusgtk::IP::PortEntry::on_spinbutton_text_entry( const Glib::ustring & text, int * position )
{
  unsigned port=0;
  std::stringstream oss;
  oss.str(m_port.get_text());
  oss >> port;
  m_port.set_value(port);
  on_port_changed();
}

void conexusgtk::IP::PortEntry::on_spinbutton_text_delete( int start, int end )
{
  static bool setting=false;
  if (setting)
    return;
  setting = true;
  unsigned port=0;
  std::stringstream oss;
  oss.str(m_port.get_text());
  oss >> port;
  m_port.set_value(port);
  on_port_changed();
  setting = false;
}


