/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUSGTK_IPPORTENTRY_H
#define CONEXUSGTK_IPPORTENTRY_H

#include <gtkmm.h>
#include <conexus/conexus.h>

namespace conexusgtk {

namespace IP {

/**
@author Rick L Vinyard Jr
*/
class PortEntry : public Gtk::VBox
{
public:
    PortEntry();
    PortEntry(conexus::IP::Address& addr);

    ~PortEntry();

    Gtk::SpinButton& get_port_button();
    Gtk::Adjustment& get_port_adjustment();

    uint32_t get_port();
    void set_port(uint32_t p);

    void connect(conexus::IP::Address& address);
    void disconnect(conexus::IP::Address& address);

    void connect_local_port(conexus::IP::IP& ip);
    void disconnect_local_port(conexus::IP::IP& ip);

    void connect_remote_port(conexus::IP::IP& ip);
    void disconnect_remote_port(conexus::IP::IP& ip);

    sigc::signal<void> signal_port_changed();

  protected:
    typedef std::set<conexus::IP::Address*> Addresses;
    typedef std::set<conexus::IP::IP*> IPSockets;
    Addresses m_connected_addresses;
    IPSockets m_connected_local_ipsockets;
    IPSockets m_connected_remote_ipsockets;
    sigc::signal<void> m_signal_port_changed;

    Gtk::SpinButton m_port;
    Gtk::Adjustment m_port_adjustment;

    virtual void on_port_changed();

    void on_spinbutton_text_entry( const Glib::ustring & text, int * position );
    void on_spinbutton_text_delete(int start, int end);

  private:
    void setup_widget();

};

}

}

#endif
