/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUSGTKSERIALCOMBOBOX_H
#define CONEXUSGTKSERIALCOMBOBOX_H

#include <gtkmm.h>
#include <hal/libhal.h>

#include <conexus/serial.h>

namespace conexusgtk {

/**
@author Rick L Vinyard Jr
*/
class SerialComboBox : public Gtk::ComboBox
{
public:
    SerialComboBox();

    ~SerialComboBox();

    bool connect(conexus::Serial& serial, bool replace=false);
    conexus::Serial* get_connected();

    bool disconnect();

    std::string get_device();

    sigc::signal<void>& signal_device_changed();

  protected:
    DBusError m_dbus_error;
    LibHalContext *m_hal_ctx;
    conexus::Serial* m_connected;
    sigc::signal<void> m_signal_device_changed;

    bool m_hal_ctx_status;

    void load_from_hal();

    class ModelColumns: public Gtk::TreeModel::ColumnRecord {
      public:
        ModelColumns() {
          add(description); add(device); }

          Gtk::TreeModelColumn<Glib::ustring> description;
          Gtk::TreeModelColumn<Glib::ustring> device;
    };

    ModelColumns m_modelcolumns;
    Glib::RefPtr<Gtk::ListStore> m_reftreemodel;

    virtual void on_changed();

};

}

#endif
