/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include <conexus/conexus.h>

#include <iostream>

using namespace conexus;
using namespace std;

typedef struct datagram {
  uint8_t ihl:4;
  uint8_t version:4;
  uint8_t tos;
  uint16_t tl;
  uint16_t id;
  uint16_t fo;
  uint8_t ttl;
  uint8_t protocol;
  uint16_t checksum;
  uint32_t source;
  uint32_t destination;
  uint8_t data[64];
} datagram;

int main(int argc, char* argv[]) {
  LL::Packet packet;
  LL::Address lladdr;
  IP::Address source, dest;

  conexus::init();

  vector<string> ifnames = get_interface_names();
  for (vector<string>::iterator i = ifnames.begin(); i != ifnames.end(); i++)
    cout << *i << " : " << get_interface_index(*i) << endl;

  lladdr.set_interface("eth0");

  datagram dg;
  source.set_hostname("192.168.10.11");
  dest.set_hostname("192.168.10.12");
  dg.version = 4;
  dg.ihl = 5;
  dg.tos = 0;
  dg.tl = htons(sizeof(datagram));
  dg.fo = htons(2<<13);
  dg.ttl = 42;
  dg.protocol = 1;
  dg.checksum = htons(0xbb75);
  dg.source = htonl(source.get_address());
  dg.destination = htonl(dest.get_address());
  dg.data[0] = 0x08; // ICMP ping request
  dg.data[1] = 0x00; // ICMP code
  dg.data[2] = 0x38; dg.data[3] = 0x9b; // ICMP checksum
  dg.data[4] = 0x42; dg.data[5] = 0x53; // ICMP identifier
  dg.data[6] = 0x00; dg.data[7] = 0x01; // ICMP sequence

  uint8_t data[] = {0x45, 0x00, 0x00, 0x27, 0x00, 0x00, 0x40, 0x00, 0x40, 0x11, 0x24, 0xb5, 0x0a, 0x08, 0x01, 0x01, 0x0a, 0x08, 0x01, 0x01, 0x80, 0x40, 0x05, 0xdc, 0x00, 0x13, 0x5e, 0x90, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x00};


  packet.writeto(lladdr, &dg, sizeof(datagram));
  packet.set_interface(1);
  packet.write(data, sizeof(data));

  return 0;
}
