/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "mainwindow.h"
#include <iostream>
#include <sstream>

void print_data1(conexus::Data d) {
  static conexus::Data sd;
std::cout << "Responding thread pid: " << pthread_self() << std::endl;
  sd = d;
  std::cout << "<1> Received " << d.size << " bytes of data (" << *((uint64_t*)d.data.get()) << ") [" << d << "]\n";
}

MainWindow::MainWindow()
{
  // Sets the border width of the window.
  set_border_width(10);

  // Sets a default size for the window so we don't start with a sliver.
  // This is probably one of the first things you should change.
  set_default_size(300,200);

  Gtk::VBox* vbox = Gtk::manage(new Gtk::VBox());

  vbox->pack_start(m_ddentry, Gtk::PACK_SHRINK);
  vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));

  vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));
  vbox->pack_start(m_hostentry, Gtk::PACK_SHRINK);
  vbox->pack_start(m_portentry, Gtk::PACK_SHRINK);
  m_hostentry.connect(m_addr);
  m_portentry.connect(m_addr);
  vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));

  vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));
  vbox->pack_start(m_blocker, Gtk::PACK_SHRINK);
  vbox->pack_start(m_hostportentry, Gtk::PACK_SHRINK);
  m_blocker.connect(m_udp, false, true);
  m_hostportentry.connect_remote_address(m_udp);
  m_udp.signal_read_write_block_changed().connect(sigc::mem_fun(*this, &MainWindow::start_stop));
  vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));

  vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));
  vbox->pack_start(m_addr_host, Gtk::PACK_SHRINK);
  vbox->pack_start(m_addr_port, Gtk::PACK_SHRINK);
  vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));

  vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));
  vbox->pack_start(m_serialbox, Gtk::PACK_SHRINK);
  vbox->pack_start(m_serial_transmit, Gtk::PACK_SHRINK);
  m_serial_transmit.set_label("Transmit serial data");
  m_serial_transmit.signal_clicked().connect(sigc::mem_fun(*this, &MainWindow::on_serial_transmit));
  vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));

  vbox->pack_start(*(Gtk::manage(new Gtk::HSeparator())));
  vbox->pack_start(m_serialdevice, Gtk::PACK_SHRINK);

  on_host_changed(false);
  on_port_changed();

  m_hostentry.signal_host_changed().connect(sigc::mem_fun(*this, &MainWindow::on_host_changed));
  m_portentry.signal_port_changed().connect(sigc::mem_fun(*this, &MainWindow::on_port_changed));

  m_hostportentry.signal_host_changed().connect(sigc::mem_fun(*this, &MainWindow::on_host_changed));
  m_hostportentry.signal_port_changed().connect(sigc::mem_fun(*this, &MainWindow::on_port_changed));

  m_serialbox.connect(m_serial);
  on_serial_changed();
  m_serialbox.signal_changed().connect(sigc::mem_fun(*this, &MainWindow::on_serial_changed));

  add(*vbox);
  show_all_children();

  std::cout << "Main thread pid: " << pthread_self() << std::endl;
  udp1.set_local_port(1500);
  udp1.connect_to_data(sigc::ptr_fun(&print_data1));
  udp1.set_responsiveness(5);
  udp1.start(true);

}

MainWindow::~MainWindow()
{
}

void MainWindow::on_host_changed( bool b)
{
    m_addr_host.set_text(m_addr.get_hostname());
}

void MainWindow::on_port_changed( )
{
  std::ostringstream ss;
  ss << m_addr.get_port();
  m_addr_port.set_text(ss.str());
}

void MainWindow::on_serial_changed( )
{
  m_serialdevice.set_text(m_serial.get_device());
}

bool MainWindow::send()
{
  static char data[] = "0123456789";
  static conexus::Data d(data, 11);
  m_udp.set_write_without_connect(true);
  m_udp << d;
}

void MainWindow::start_stop(bool r, bool w) {
  if (!w)
  m_timer = Glib::MainContext::get_default()->signal_timeout().connect(sigc::mem_fun(*this, &MainWindow::send), 1000);
  else
    m_timer.disconnect();

}

void MainWindow::on_serial_transmit( )
{
  char data[] = "0123456789\n";
  m_serial.write(data, 12);
}


