#include <string.h>
#include "confuse.h"

int main(void)
{
	cfgbool_t verbose = cfg_false;
	char *server = strdup("gazonk");
	double delay = 1.356e-32;
	char *username = NULL;
	int debug = 1;

	cfgopt_t opts[] = {
		CFG_SIMPLE_BOOL("verbose", &verbose),
		CFG_SIMPLE_STR("server", &server),
		CFG_SIMPLE_STR("user", &username),
		CFG_SIMPLE_INT("debug", &debug),
		CFG_SIMPLE_FLOAT("delay", &delay),
		CFG_END()
	};
	cfg_t *cfg;

	cfg = cfg_init(opts, 0);
	cfg_parse(cfg, "simple.conf");
	cfg_free(cfg);

	printf("verbose: %s\n", verbose ? "true" : "false");
	printf("server: %s (%s)\n", server, cfg_getstr(cfg, "server"));
	printf("username: %s\n", username);
	printf("debug: %d\n", debug);
	printf("delay: %G\n", delay);

	return 0;
}
