#include "confuse.h"

int alias_cb(cfg_t *cfg, int argc, const char **argv)
{
	if(argc != 2) {
		cfg_error(cfg, "wrong number of arguments to alias_cb()");
		return 1;
	}
	printf("alias: '%s' == '%s'\n", argv[0], argv[1]);
	return 0;
}

int main(void)
{
	cfgopt_t bookmark_opts[] = {
		CFG_STR("machine", 0, 0),
		CFG_INT("port", -1, 0),
		CFG_STR("login", 0, 0),
		CFG_STR("password", 0, 0),
		CFG_BOOL("anonymous", cfg_false, 0),
		CFG_STR("directory", 0, 0),
		CFG_STR("sftp", 0, 0),
		CFG_BOOL("noupdate", cfg_false, 0),
		CFG_BOOL("passive-mode", cfg_false, 0),
		CFG_END()
	};
	cfgopt_t opts[] = {

		CFG_FUNC("include", 1, &cfg_include),

		CFG_BOOL("autologin", cfg_true, 0),
		CFG_BOOL("autoreconnect", cfg_true, 0),
		CFG_BOOL("quit-on-eof", cfg_true, 0),
		CFG_BOOL("read-netrc", cfg_true, 0),
		CFG_BOOL("use-passive-mode", cfg_true, 0),
		CFG_BOOL("reverse-dns", cfg_true, 0),
		CFG_BOOL("verbose", cfg_false, 0),
		CFG_BOOL("debug", cfg_false, 0),
		CFG_BOOL("trace", cfg_false, 0),
		CFG_STR("ssh-program", "/usr/bin/ssh", 0),
		CFG_STR("sftp-server-program", "/usr/libexec/sftp-server", 0),
		CFG_BOOL("inhibit-startup-syst", cfg_false, 0),
		CFG_BOOL("use-env-string", cfg_true, 0),
		CFG_BOOL("remote-completion", cfg_true, 0),
		CFG_STR("auto-bookmark", "yes", 0),
		CFG_BOOL("auto-bookmark-save-passwd", cfg_false, 0),
		CFG_BOOL("auto-bookmark-silent", cfg_false, 0),
		CFG_STR("default-type", "binary", 0),
		CFG_STR("default-mechanism", "krb4", CFGF_LIST),
		CFG_STR("ascii-transfer-mask", 0, CFGF_LIST),
		CFG_BOOL("beep-after-long-command", cfg_true, 0),
		CFG_INT("long-command-time", 30, 0),
		CFG_INT("command-timeout", 42, 0),
		CFG_INT("connection-timeout", 30, 0),
		CFG_INT("connect-attempts", 10, 0),
		CFG_INT("connect-wait-time", 30, 0),
		CFG_BOOL("use-history", cfg_true, 0),
		CFG_INT("history-max", 256, 0),
		CFG_STR("startup-local-directory", 0, 0),
		CFG_STR("nohup-mailaddress", 0, 0),
		CFG_STR("sendmail-path", "/usr/sbin/sendmail", 0),
		CFG_STR("load-taglist", "yes", 0),
		CFG_BOOL("tilde", cfg_true, 0),
		CFG_FUNC("alias", 2, &alias_cb),
		CFG_STR("prompt1", "yafc> ", 0),
		CFG_STR("prompt2", "yafc %h> ", 0),
		CFG_STR("prompt3", "yafc %u@%h:%42~> ", 0),
		CFG_STR("xterm-title1", "\e]0;yafc\x07", 0),
		CFG_STR("xterm-title2", "\e]0;yafc %h\x07", 0),
		CFG_STR("xterm-title3", "\e]0;yafc %u@%h:%~\x07", 0),
		CFG_STR("xterm-title-terms", "{xterm, xterm-debian, rxvt}", CFGF_LIST),
		CFG_STR("transfer-begin-string", "%-70R\n", 0),
		CFG_STR("transfer-string", "%5p%% [%25v] %s/%S ETA %e %B", 0),
		CFG_STR("transfer-end-string", 0, 0),
		CFG_STR("transfer-xterm-string", "\e]0;%p%% - %R - yafc\x07", 0),
		CFG_INT("proxy-type", 0, 0),
		CFG_STR("proxy-host", 0, 0),
		CFG_STR("proxy-exclude", "{localhost, .localnet}", CFGF_LIST),
		CFG_SEC("bookmark", bookmark_opts, CFGF_MULTI | CFGF_TITLE),
		CFG_END()
	};
	int i;
	cfg_t *cfg;
	cfg_t *sec;
	int ret;

	printf("Using %s\n\n", confuse_copyright);

	cfg = cfg_init(opts, 0);
	ret = cfg_parse(cfg, "yafcrc");
	if(ret == -1) {
		perror("./test.conf");
		return 1;
	} else if(ret == 1)
		return 2;

	puts("parsing successful!");

	for(i = 0; i < cfg_size(cfg, "bookmark"); i++) {
		sec = cfg_getnsec(cfg, "bookmark", i);
		printf("bookmark #%u = %s\n", i+1, cfg_title(sec));
	}

	cfg_free(cfg);
	return 0;
}
