#!/bin/bash
########################################################################
# 'make.sh' for the program consoleSudoku.            
#                                                           
# Version: 0.11
# Date: 03-June-2016
########################################################################
#
# Copyright (C) <2016>  <author: Peter Rossnagel>  <contact: pewrn@t-online.de>
# -----------------------------------------------------------------------------
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 3 as published by
# the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
########################################################################
# 'make.sh' based on the code and explanations given at:
# http://wiki.freepascal.org/Deploying_Your_Application
# especially:
# http://wiki.freepascal.org/Deploying_Your_Application#Creating_a_Makefile_for_your_Lazarus_software
#
# License information: 
# http://wiki.freepascal.org/Licensing
########################################################################
set -e

# Detects and parses the architecture
ARCH=$(uname -m)
case "$ARCH" in 
     "i686") ARCH="i386";;
     "i586") ARCH="i386";;
     "i486") ARCH="i386";; 
esac
echo "Target architecture: $ARCH"
     
if [ $ARCH = "x86_64" ]; then LCLDir="/usr/lib64/lazarus/"
else LCLDir="/usr/lib/lazarus"
fi
echo "LAZTarget: $LCLDir"
     
# Building the IDE and LCL
OS="linux"
echo "Target operating system: $OS"
     
# Command line to build the sofware
VER=$(fpc -iW)
echo "Compiler version: $VER"
     
echo "Compiling project..."
fpc -MObjFPC -Scghi -Cg -O1 -g -gl -l -vewnhibq -Fu. -Fulib/$ARCH-$OS -o./consoleSudoku consoleSudoku.pas
