/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptflanger";
declare description "flanger filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.11";
declare license "GPL 3.0 or later";

//link the librarys
si = library("signals.lib");
ma = library("math.lib");
en = library("envelopes.lib");
ba = library("basics.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
	     nchannels = 2;// number of channels; 1 for mono, 2 for stereo
	   };

// the function that decribes the flanger effect
flanger = @(ma.SR*envelopephase)*(en.ar(atrt,atrt,pulse))
with {
  phase = hslider("[1][lv2:integer]phase", 1, 1, 1000, 1)/1000;
  shift = hslider("[2][lv2:integer]phase shift",1,1,1000,1)/1000;

  atrt =  ba.samp2sec(ma.SR)*phase;
  pulse = ba.pulsen(phase*ma.SR,2*phase*ma.SR);
  envelopephase = en.ar(shift,shift,pulse);
};

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par( i, constant.nchannels,cptbasics.bargraphinput(i) :

				     //cptbasics.Ndrywetmonofx(i, flanger ) : //for N number of channels
				     
				     cptbasics.stereodrywetmonofx(i, flanger) ://for 2 channels only; enables effect balance slider
	                             cptbasics.bargraphoutput(i));

