/* 
    Copyright (C) 2024, 2025, Johannes Merten <coldemail@posteo.net>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
    */

declare name "cptdelay";
declare description "delay filter";
declare author "Johannes Merten";
declare copyright "Johannes Merten (coldemail@posteo.net)";
declare version "0.14";
declare license "GPL 3.0 or later";

//link the libraries
si = library("signals.lib");
ma = library("maths.lib");
ba = library("basics.lib");
de = library("delays.lib");
cptbasics = library("lib/basics.lib");

// constants used in this program
constant = environment {
	     nchannels = 2; //number of channels; 1 for mono, 2 for stereo
};


//a slider for the feedback
feedback = hslider("[1]feedback", 0.5,0,1,0.01) : si.smoo;

//a slider for the random gain
randomgain = hslider("[2][lv2:integer]randomize feedback",0,0,100,1)/100 : si.smoo;

//a slider for the delay
M = 60 / hslider("[3][lv2:integer]delay bpm",120,1,500,1) : si.smoo;// M in seconds

//a slider for the gain
gain = hslider("[4]gain",1,0,1,0.01) : si.smoo;


//calculating the echo
monoecho(d,f) = +~bounce(d) * feedback(f) : smoothd with {

  //a smooth delay
  bounce(d) = de.sdelay(ma.SR * 60,1024,d);

  //feedback with random gain if randomgain > 0
  feedback(f) = f * (1 - randomgain,4 * randomgain * noised(12345,d) :>_);

  //smoothing
  smoothd = si.smooth(ba.tau2pole(0.001));
};

noised(seed, period) = random / RANDMAX
with {
  mask = 4294967295; // 2^32-1
  random = +(seed) ~ ba.sAndH(clock, *(1103515245) & mask); // "linear congruential"
  clock = ba.period(period) == 0;
  RANDMAX = 2147483647.0; // = 2^31-1 = MAX_SIGNED_INT in 32 bits
};

// the process, that is going to be executed; contains the functions that are described before
// constant.nchannels in parallel
process = par( i, constant.nchannels,(cptbasics.bargraphinput(i) :

				      //cptbasics.Ndrywetmonofx(i, (monoecho(ma.SR*M,feedback) * gain) ) )://for N number of channels

				      
				      cptbasics.stereodrywetmonofx(i,(monoecho(ma.SR*M,feedback) * gain) ) ): //for 2 channels only; enables effect balance slider
				     
	                             cptbasics.bargraphoutput(i));
