/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2005 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib-object.h>

#include <ccc/canvas.h>
#include <ccc/canvas-priv.h>

#ifndef SLIDE_DISPLAY_H
#define SLIDE_DISPLAY_H

G_BEGIN_DECLS

typedef struct _CriaSlideDisplay CriaSlideDisplay;
typedef struct _CriaSlideDisplayClass CriaSlideDisplayClass;
typedef struct _CriaSlideDisplayPrivate CriaSlideDisplayPrivate;

GType		  cria_slide_display_get_type	    (void);
gdouble		  cria_slide_display_get_slide_zoom (CriaSlideDisplay	* self);
CriaSlideDisplay* cria_slide_display_new            (void);
void		  cria_slide_display_set_slide_zoom (CriaSlideDisplay	* self,
						     gdouble		  slide_zoom);

#define CRIA_TYPE_SLIDE_DISPLAY			(cria_slide_display_get_type())
#define CRIA_SLIDE_DISPLAY(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_SLIDE_DISPLAY, CriaSlideDisplay))
#define CRIA_SLIDE_DISPLAY_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), CRIA_TYPE_SLIDE_DISPLAY, CriaSlideDisplayClass))
#define CRIA_IS_SLIDE_DISPLAY(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_SLIDE_DISPLAY))
#define CRIA_IS_SLIDE_DISPLAY_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_SLIDE_DISPLAY))
#define CRIA_SLIDE_DISPLAY_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_SLIDE_DISPLAY, CriaSlideDisplayClass))

struct _CriaSlideDisplay {
	CriaCanvas	  canvas;
};

struct _CriaSlideDisplayClass {
	CriaCanvasClass	  canvas_class;
};

G_END_DECLS

#endif /* !SLIDE_DISPLAY_H */

