/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "slide-list.h"

enum {
	PROP_0,
	PROP_ATTRIBUTE
};

enum {
	SIGNAL,
	N_SIGNALS
};

enum {
	COLUMN_PREVIEW,
	COLUMN_TITLE,
	COLUMN_INDEX,
	N_COLUMNS
};

static	void	cria_slide_list_init	       (CriaSlideList	* self);
static	void	cria_slide_list_get_property   (GObject		* object,
						guint		  prop_id,
						GValue		* value,
						GParamSpec	* param_spec);
static	void	cria_slide_list_set_property   (GObject		* object,
						guint		  prop_id,
						const	GValue	* value,
						GParamSpec	* param_spec);

static	guint	cria_slide_list_signals[N_SIGNALS] = { 0 };

static	void	cria_slide_list_signal	       (CriaSlideList	* template,
						const	gchar	* string);

static void
cria_slide_list_class_init (CriaSlideListClass	* cria_slide_list_class)
{
	GObjectClass	* g_object_class;

	g_object_class = G_OBJECT_CLASS(cria_slide_list_class);
#if 0
	/* setting up signal system */
	cria_slide_list_class->signal = cria_slide_list_signal;

	cria_slide_list_signals[SIGNAL] = g_signal_new (
			"signal",
			CRIA_TYPE_SLIDE_LIST,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (
				CriaSlideListClass,
				signal),
			NULL,
			NULL,
			g_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			0);
#endif
	/* setting up property system */
	g_object_class->set_property = cria_slide_list_set_property;
	g_object_class->get_property = cria_slide_list_get_property;

	g_object_class_install_property (
			g_object_class,
			PROP_ATTRIBUTE,
			g_param_spec_string (
				"attribute",
				"Attribute",
				"A simple unneccessary attribute that does nothing special except "
				"being a demonstration for the correct implementation of a GObject "
				"property",
				"default_value",
				G_PARAM_READWRITE | G_PARAM_CONSTRUCT)
			);
}

const char*
cria_slide_list_get_attribute (
		CriaSlideList	* self)
{
	g_return_val_if_fail (CRIA_IS_SLIDE_LIST(self), NULL);
	
	return self->attribute;
}

static void
cria_slide_list_get_property (
		GObject		* object,
		guint		  prop_id,
		GValue		* value,
		GParamSpec	* param_spec)
{
	CriaSlideList	* self;

	self = CRIA_SLIDE_LIST (object);

	switch (prop_id)
	{
	case PROP_ATTRIBUTE:
		g_value_set_string (
				value,
				self->attribute);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (
				object,
				prop_id,
				param_spec);
		break;
	}
}

GType
cria_slide_list_get_type (void)
{
	static GType	type = 0;

	if (!type)
	{
		const GTypeInfo info = {
			sizeof (CriaSlideListClass),
			NULL,	/* base initializer */
			NULL,	/* base finalizer */
			(GClassInitFunc)cria_slide_list_class_init,
			NULL,	/* class finalizer */
			NULL,	/* class data */
			sizeof (CriaSlideList),
			0,
			(GInstanceInitFunc)cria_slide_list_init,
			0
		};

		type = g_type_register_static (
				GTK_TYPE_TREE_VIEW,
				"CriaSlideList",
				&info,
				0);
	}

	return type;
}

static void
cria_slide_list_init(CriaSlideList *self) {
	GtkTreeViewColumn	* column;
	GtkCellRenderer		* renderer;
	
	GtkTreeStore	* store = gtk_tree_store_new(
			N_COLUMNS,
			GDK_TYPE_PIXBUF,
			G_TYPE_STRING,
			G_TYPE_UINT);
	
	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(
			column,
			"Slides");
	gtk_tree_view_append_column(
			GTK_TREE_VIEW(self),
			column);
	gtk_tree_view_set_model(
			GTK_TREE_VIEW(self),
			GTK_TREE_MODEL(store));
	return;
}

GtkWidget*
cria_slide_list_new(void) {
	CriaSlideList	* self = g_object_new(CRIA_TYPE_SLIDE_LIST, NULL);

	g_assert(GTK_IS_WIDGET(self));

	return self;
}

void
cria_slide_list_set_attribute (
		CriaSlideList	* self,
		const gchar	* attribute)
{
	g_return_if_fail (CRIA_IS_SLIDE_LIST(self));

	if (self->attribute != NULL)
		g_free (self->attribute);

	self->attribute = g_strdup (attribute);

	g_object_notify (G_OBJECT (self), "attribute");
}

static void
cria_slide_list_set_property (
		GObject		* object,
		guint		  prop_id,
		const	GValue	* value,
		GParamSpec	* param_spec)
{
	CriaSlideList	* self;
	
	self = CRIA_SLIDE_LIST (object);
	
	switch (prop_id)
	{
	case PROP_ATTRIBUTE:
		cria_slide_list_set_attribute (
				self,
				g_value_get_string (value));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (
				object,
				prop_id,
				param_spec);
		break;
	}
}

