/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef CC_CANVAS_VIEW_H
#define CC_CANVAS_VIEW_H

#include <glib-object.h>
#include <gtkcairo.h>

#include "cc-canvas.h"

G_BEGIN_DECLS

typedef struct _CCCanvasView CCCanvasView;
typedef struct _CCCanvasViewClass CCCanvasViewClass;

GtkWidget	* cc_canvas_view_new		       (void);
GType		  cc_canvas_view_get_type	       (void);
void		  cc_canvas_view_set_canvas	       (CCCanvasView	* self,
							CCCanvas	* canvas);
const gchar*	  cc_canvas_view_get_attribute	       (CCCanvasView	* self);
void		  cc_canvas_view_set_attribute	       (CCCanvasView	* self,
							const char	* attribute);

#define CC_TYPE_CANVAS_VIEW		(cc_canvas_view_get_type ())
#define CC_CANVAS_VIEW(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CC_TYPE_CANVAS_VIEW, CCCanvasView))
#define CC_CANVAS_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), CC_TYPE_CANVAS_VIEW, CCCanvasViewClass))
#define CC_IS_CANVAS_VIEW(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CC_TYPE_CANVAS_VIEW))
#define CC_IS_CANVAS_VIEW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CC_TYPE_CANVAS_VIEW))
#define CC_CANVAS_VIEW_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CC_TYPE_CANVAS_VIEW, CCCanvasViewClass))

struct _CCCanvasView {
	GtkCairo	  base_instance;
	gchar		* attribute;
};

struct _CCCanvasViewClass {
	GtkCairoClass	  base_class;
#if 0
	/* signals */
	void (*signal)	       (CCCanvas	* self,
				const	gchar	* string);
#endif
};

G_END_DECLS

#endif /* CC_CANVAS_VIEW_H */

