/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef CC_CANVAS_H
#define CC_CANVAS_H

#include <glib-object.h>

#include "cc-canvas-group.h"

G_BEGIN_DECLS

typedef struct _CCCanvas CCCanvas;
typedef struct _CCCanvasClass CCCanvasClass;

CCCanvas	* cc_canvas_new		       (void);
GType		  cc_canvas_get_type	       (void);
CCCanvasGroup	* cc_canvas_get_root	       (CCCanvas	* self);
const gchar*	  cc_canvas_get_attribute      (CCCanvas	* self);
void		  cc_canvas_set_attribute      (CCCanvas	* self,
						const char	* attribute);

#define CC_TYPE_CANVAS			(cc_canvas_get_type ())
#define CC_CANVAS(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CC_TYPE_CANVAS, CCCanvas))
#define CC_CANVAS_CLASS(klass)		(G_TYPE_CHACK_CLASS_CAST((klass), CC_TYPE_CANVAS, CCCanvasClass))
#define CC_IS_CANVAS(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CC_TYPE_CANVAS))
#define CC_IS_CANVAS_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CC_TYPE_CANVAS))
#define CC_CANVAS_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CC_TYPE_CANVAS, CCCanvasClass))

struct _CCCanvas {
	GObject		  base_instance;
	gchar		* attribute;
};

struct _CCCanvasClass {
	GObjectClass	  base_class;

	/* signals */
	void (*signal)	       (CCCanvas	* self,
				const	gchar	* string);
};

G_END_DECLS

#endif /* CC_CANVAS_H */

