/* this file is part of criawips, a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <glib-object.h>
#include <libgnomecanvas/gnome-canvas.h>

#include <goffice/utils/go-units.h>

#ifndef DISPLAY_H
#define DISPLAY_H

G_BEGIN_DECLS

typedef struct _CriaDisplay CriaDisplay;
typedef struct _CriaDisplayClass CriaDisplayClass;
typedef struct _CriaDisplayPrivate CriaDisplayPrivate;

go_unit_t	  cria_display_get_padding     (CriaDisplay	* self);
GnomeCanvasGroup* cria_display_get_top_group   (CriaDisplay	* self);
GType		  cria_display_get_type	       (void);
gdouble		  cria_display_get_zoom	       (CriaDisplay	* self);
CriaDisplay*	  cria_display_new	       (void);
void		  cria_display_set_padding     (CriaDisplay	* self,
						go_unit_t	  padding);
void		  cria_display_set_sizes       (CriaDisplay	* self,
						const GoPoint	* slide,
						const GoPoint	* display);
void		  cria_display_set_zoom	       (CriaDisplay	* self,
						gdouble		  zoom);

#define CRIA_TYPE_DISPLAY		(cria_display_get_type ())
#define CRIA_DISPLAY(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), CRIA_TYPE_DISPLAY, CriaDisplay))
#define CRIA_DISPLAY_CLASS(klass)	(G_TYPE_CHACK_CLASS_CAST((klass), CRIA_TYPE_DISPLAY, CriaDisplayClass))
#define CRIA_IS_DISPLAY(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), CRIA_TYPE_DISPLAY))
#define CRIA_IS_DISPLAY_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), CRIA_TYPE_DISPLAY))
#define CRIA_DISPLAY_GET_CLASS(object)	(G_TYPE_INSTANCE_GET_CLASS((object), CRIA_TYPE_DISPLAY, CriaDisplayClass))

struct _CriaDisplay {
	GnomeCanvas	    base_instance;
	CriaDisplayPrivate* priv;
};

struct _CriaDisplayClass {
	GnomeCanvasClass	  base_class;
};

G_END_DECLS

#endif /* !DISPLAY_H */

