/* this file is part of criawips a gnome presentation application
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2004 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "slide-view.h"

#include "slide.h"

static void
cria_slide_view_class_init(gpointer iface) {
//	GType	type = G_TYPE_FROM_INTERFACE(iface);

	g_object_interface_install_property(iface,
					    g_param_spec_object("slide",
						    		"Slide",
								"The slide that's being displayed in the SlideView",
								CRIA_TYPE_SLIDE,
								(G_PARAM_CONSTRUCT | G_PARAM_READWRITE)));
}

GType
cria_slide_view_get_type(void) {
	static GType type = 0;

	if(!type) {
		static const GTypeInfo info = {
			sizeof(CriaSlideViewClass),
			NULL, /* GBaseInitFunc */
			NULL, /* GBaseFinalizeFunc */
			(GClassInitFunc)cria_slide_view_class_init
		};

		type = g_type_register_static(G_TYPE_INTERFACE,
					      "CriaSlideView",
					      &info,
					      0);
	}

	return type;
}

void
_cria_slide_view_install_properties(GObjectClass *klass) {
	g_object_class_override_property(klass, CRIA_SLIDE_VIEW_PROP_SLIDE, "slide");
}

