/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2006  Sven Herzberg <herzi@gnome-de.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "ce-window.h"

#include <gtk/gtk.h>
#include <ccc.h>

GtkWidget*
ce_window_new(void) {
	return g_object_new(CE_TYPE_WINDOW, NULL);
}

/* GType */
G_DEFINE_TYPE(CEWindow, ce_window, HERZI_TYPE_MAIN_WINDOW);

static void
ce_window_init(CEWindow* self) {
	GtkWidget* hpaned = gtk_hpaned_new();
	GtkWidget* scrolled = gtk_scrolled_window_new(NULL, NULL);

	self->canvas_view = cc_view_widget_new();
	gtk_container_add(GTK_CONTAINER(scrolled), self->canvas_view);
	gtk_paned_pack1(GTK_PANED(hpaned), scrolled, TRUE, FALSE);

	self->sidebar = gtk_label_new("sidebar");
	gtk_paned_pack2(GTK_PANED(hpaned), self->sidebar, FALSE, FALSE);

	gtk_widget_show_all(hpaned);
	gtk_box_pack_start_defaults(GTK_BOX(HERZI_MAIN_WINDOW(self)->vbox), hpaned);
}

static void
ce_window_class_init(CEWindowClass* self_class) {}

