# encodep.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from yahoodef import *
import struct

def login(user, cookie):
	data = '%s\x01%s' % (user, cookie)
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0x100L, 0x1L, 0, datalen, data)

def logout():
	data = 'logout'
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0xa6L, 0x71L, 0, datalen, data)

def join(room):
	data = 'join %s' % room
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0xa3L, 0x71L, 0, datalen, data)

def away(text):
	if text:
		data = ' %s%s%s%s' % (DELIM, '10', DELIM,  text)
	else:
		data = ' %s%s%s ' % (DELIM, '11', DELIM)
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0x100L, AWAY, 0, datalen, data)

def back():
	data = ' %s%s%s ' % (DELIM, '0', DELIM)
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0xa3L, AWAY, 0, datalen, data)

def comment(text):
	data = 'C\x01%s' % text
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0x100L, COMMENT, 0, datalen, data)

def pm(me, user, text):
	data = '%s\x01%s\x01%s\x01-1:-1' % (me, user, text)
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0x17DL, 0x45L, 0, datalen, data)

def emote(text):
	data = ' \x01%s' % text
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0x17DL, 0x43, 0, datalen, data)

def invite(text):
	data = '%s' %  text
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0x17DL, 0x17L, 0, datalen, data)

def invite2(text):
	data = 'invite %s' %  text
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0x17DL, 0x71L, 0, datalen, data)

def thought(text):
	data = ' \x01. o O ( %s )' % text
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0x100L, EMOTE, 0, datalen, data)

def goto(user):
	data = 'goto %s' % user
	datalen = len(data)
	fmt = '!4sllhh%ss' % datalen
	return struct.pack(fmt, 'YCHT', 0xa3L, 0x71L, 0, datalen, data)

def ping():
	fmt = '!4sllhh'
	return struct.pack(fmt,'YCHT', 0xa3L, 0x62L, 0, 0)

def do(d):
	if d.has_key('type'):
		t = d['type']
		if t == 'comment' and d.has_key('text'):
			return comment(d['text'])
		elif t == 'pm' and d.has_key('user') and d.has_key('text'):
			return pm(d['me'], d['user'], d['text'])
		elif t == 'emote' and d.has_key('text'):
			return emote(d['text'])
		elif t == 'invite' and d.has_key('text'):
			return invite(d['text'])
		elif t == 'invite2' and d.has_key('text'):
			return invite2(d['text'])
		elif t == 'thought' and d.has_key('text'):
			return thought(d['text'])
		elif t == 'away' and d.has_key('text'):
			return away(d['text'])
		elif t == 'back':
			return back()
		elif t == 'join' and d.has_key('room'):
			return join(d['room'])
		elif t == 'ping':
			return ping()
		elif t == 'logout':
			return logout()
		elif t == 'login' and d.has_key('user') and d.has_key('cookie'):
			return login(d['user'], d['cookie'])
		elif t == 'goto' and d.has_key('user'):
			return goto(d['user'])

