# cmdhelp.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

join = """/join or /j
This is how you switch from room to room.

syntax: /join <room>

example: /join programming:1"""

ignore = """/ignore or /i
This is how you ignore users.

syntax: /ignore <user>
  Where user is a chatter's nick or a regular expression.

example: /ignore james_kelly
  puts the chatter called james_kelly on your ignore list

example: /ignore james_kelly.*
  ignores james_kelly, james_kelly1962, james_kelly2000

To list all users on ignore type /ignore"""

ignorem = """/ignore* or /i*
Ignore multiple users in one go with this command.

syntax: /ignore* <user1> [user2] [user3] ...

example: /ignore* james_kelly newcastlewestend
  puts james_kelly and newcastlewestend on your ignore list."""

buddy = """/buddy or /b
Gives users pm privileges.

syntax: /buddy <user>
  Where user is the name of the chatter you want to accept pms from.

example:/buddy the_cpu_fan
  accepts all private messages from the_cpu_fan

To list all users on your buddy list type /buddy"""

quit = """/quit or /q
Quit the chat session and log out of Yahoo.

syntax: /quit [message]
  Where message is optional and can be any arbitrary string which you
  want sent to chat before actually logging out.

example: /quit catch you all later."""

emote = """: or /me
Any command that starts with ':' or /me is interpreted as an emote.
Emotes look like this:
* Your_Nick blah blah blah

syntax: <:|/me> <message>

example: :loves curphoo. heh
  would look like this in chat:
    * YourNick loves curphoo. heh

example: /me is *dying*
  would look like this in chat:
    * YourNick is *dying*"""

tell = """/tell or /msg
Send private messages.

syntax: /tell <user> <message>
  Where
    user -- the name of the chatter you want to pm
	 message -- whatever you want to say to the chatter

example: /tell kq_56 hello!

See /help buddy"""

shellexec = """!
Any command that starts with '!' is interpreted as a shell command
whose output will be sent to chat.

syntax: !<sh command>

example: !uptime

example: !df -h"""

localexec = """!!
Any command that starts with '!!' is interpreted as a shell command
whose output will be printed on the chat window but will not be sent to chat.

syntax: !!<sh command>

example: !!uptime"""

hilite_user = """/hilite-user or /hu
Highlights a user's post.

syntax: /hilite-user <user>
  Where user is the name of the chatter whose post you want highlighted

example: /hilite-user the_cpu_fan
  highlights the_cpu_fan's post

example: /hu Imparcival
  highlights IMParcival's post

To list all users on highlight type: /hu
To remove a user from the highlight list type: /hu <user>"""

hilite_string = """/hilite-string or /hs
Highlights any post where a regular expression matches.

syntax: /hilite-string <regex>

example: /hs \*dying\*
  highlights any post where the string "*dying*" appears

To remove a regex from the highlight list type: /hilite-user <regex>"""

slash = """/ or /users
List all users"""

uptime = """/uptime or /up
Shows all how superb your chat client is.

syntax: /up[time]"""

ver = """/ver or /v or /version
Shows all where you got your copy of curphoo from.

syntax: /v"""

openurl = """/openurl
Loads a url in a new web browser window. The url can be
given as an argument to the /openurl or if no arguments
are given the url used is the most recent url seen in
the chat window.

syntax: /openurl [url]

example: /openurl http://slashdot.org

example: /openurl"""

help = """Curphoo commands
/join <room>                        -- join a room
/quit [message]                     -- quit chat session
/ignore <user>                      -- ignore a user
/ignore* <user1> [user2] ...        -- ignore multiple users
/buddy <user>                       -- give a user pm privileges
/tell <user> [!]<message>           -- send user a private message
/hs <regex>                         -- highlight any post where regex matches
/hu <user>                          -- highlight user's posts
/uptime                             -- tell everyone curphoo is unbootable
/ver                                -- tell everyone you're a champ
/                                   -- list all users
! <sh command>                      -- show all you've got sh fu
!! <sh command>                     -- show yourself your sh fu
:<message>                          -- emotes

type /help <command> for more."""

helpd = {
	'/join': join,
	'join': join,
	'/quit': quit,
	'quit': quit,
	'/ignore': ignore,
	'ignore': ignore,
	'/ignore*': ignorem,
	'ignore*': ignorem,
	'/buddy': buddy,
	'buddy': buddy,
	'/tell': tell,
	'tell': tell,
	'/openurl': openurl,
	'openurl': openurl,
	'/': slash,
	'/hs': hilite_string,
	'hs': hilite_string,
	'/hu': hilite_user,
	'hu': hilite_user,
	'/ver': ver,
	'ver': ver,
	'/uptime': uptime,
	'uptime': uptime,
	'!': shellexec,
	'!!': localexec,
	'/me': emote,
	'me': emote,
	':': emote
}

