# driver.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys
import curses
import Yahoo
import Entry
import Session
import output
import cmdparser
import re
import signal
import time
#import cursex

def go(stdscr, sess_arg):
	global sess, y
	global entry, chatwin, statusbar
	global pminrow
	t0 = time.time()
	t1 = t0

	pminrow = (curses.LINES - 2) * 19
	sess = sess_arg
	sess.time = time.strftime('%H:%M')

	y = Yahoo.Client()
	y.connect(sess.server)
	y.write_message(type='login', user=sess.user, cookie=sess.cookie)

	# disable cntrl-c and other special chars
	curses.raw()

	#cursex.use_my_colours()
	curses.use_default_colors()
	curses.init_pair(0,-1,-1)
	curses.init_pair(1,1,-1)
	curses.init_pair(2,2,-1)
	curses.init_pair(3,3,-1)
	curses.init_pair(4,4,-1)
	curses.init_pair(5,5,-1)
	curses.init_pair(6,6,-1)
	curses.init_pair(7,-1,-1)

	chatwin = create_chat_window()
	statusbar = create_status_bar()
	entry = Entry.Entry()
	try:
		still_on = 1
		msgp = None
		still_on = y.chat()
		while still_on and sess.reconnect:
			chatwin.noutrefresh(pminrow,0, 0,0, curses.LINES-3, curses.COLS)
			entry.show()
			curses.doupdate()
			send_ping()
			msg = y.read_message()
			while msg:
				if msg == msgp:
					msg = None
					break
				else:
					msgp = msg
				hook(msg)
				msg = y.read_message()
				curses.doupdate()
			s = entry.edit(sess.users, sess.cmd, sess.mycmd.keys())
			pminrow = get_scroll(pminrow)
			if pminrow == 9999: still_on = 0
			if s:
				cmdparser.do(s, y, sess, chatwin, statusbar)
				if re.match('^/(exit|bye) *$', s, re.I):
					break
			still_on = y.chat()
			if not still_on:
				del y
				y = Yahoo.Client()
				y.connect(sess.server)
				sess.show_user_list = 0
				y.write_message(type='login', user=sess.user, cookie=sess.cookie)
				still_on=1
	finally:
		sess.clean()
		y.disconnect()

def send_ping():
	time_now = time.strftime('%H:%M')
	if time_now != sess.time:
		sess.time = time_now
		output.status(statusbar, sess)

def create_chat_window():
	win = curses.newpad(((curses.LINES-2)*20)+1, curses.COLS)
	win.idlok(1)
	win.scrollok(1)
	win.erase()
	win.move((curses.LINES-2)*19, 0)
	return win

def create_status_bar():
	win = curses.newwin(1, curses.COLS, curses.LINES-2,0)
	win.idlok(0)
	win.clearok(1)
	win.scrollok(0)
	win.bkgdset(ord(' '), curses.color_pair(7)|curses.A_REVERSE)
	win.erase()
	win.noutrefresh()
	return win

def get_scroll(pmin):
	pud = entry.pp()
	if pud == 1:
		if pmin > 0:
			pmin = pmin - (curses.LINES-2)
	elif pud == -1:
		if pmin < ((curses.LINES-2)*19):
			pmin = pmin + (curses.LINES-2)
	elif pud == 999:
		chatwin.refresh(pminrow,0, 0,0, curses.LINES-3, curses.COLS)
		statusbar.clear()
		output.status(statusbar, sess)
	elif pud == 9999:
		pmin = 9999
	return pmin

def hook(msg):
	if msg['type'] == 'login':
		y.write_message(type='join', room=sess.room)
	elif msg['type'] == 'enter':
		c = msg['user']
		if c not in sess.users:
			sess.users.append(msg['user'])
		output.status(statusbar, sess)
	elif msg['type'] == 'join':
		sess.users = msg['users']
		sess.room = msg['room']
		output.status(statusbar, sess)
	elif msg['type'] == 'exit':
		c = msg['user']
		if c in sess.users:
			sess.users.remove(msg['user'])
		output.status(statusbar, sess)
	elif msg['type'] == 'pm':
		if not (msg['user'].lower() in sess.buddies):
			msg['type'] = 'crap'
	if msg.has_key('text'):
		if not msg['text']:
			msg['type'] = 'crap'
		else:
			try:
				for e in sess.myregex:
					if re.search(e, msg['text'], re.I):
						msg['type'] = 'crap'
						break
			except:
				pass
	if msg.has_key('user'):
		u = msg['user']
		for e in sess.ignores:
			try:
				if re.match(r'%s' % e, u, re.I):
					msg['type'] = 'crap'
					break
			except:
				pass
		else:
			if msg.has_key('text'):
				x = re.search(r'(http://|ftp://|www)[^ ]+ ?', msg['text'])
				if x: sess.url = x.group()
				
	output.message(chatwin, msg, sess.user, sess)
	output.log(msg, sess.log)

