# shexec.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import popen2
import signal
import os

TIMEOUT_VALUE = 120

def time_out_func(signum, frame):
	raise IOError, "TIME OUT"

def clean_up(l):
	caught = []

	for p in l:
		try:
			os.waitpid(p, os.WNOHANG)
		except os.error:
			caught.append(p)

	for p in caught:
		l.remove(p)

def do(cmd, bufsize, proc_list):
	signal.signal(signal.SIGALRM, time_out_func)
	result = "[process timed out]"

	proc = popen2.Popen4(cmd, bufsize)
	proc.tochild.flush()
	proc.tochild.close()

	signal.alarm(TIMEOUT_VALUE)
	try:
		result = proc.fromchild.read(bufsize)
	except IOError: 
		pass
	signal.alarm(0)

	proc.fromchild.close()
	os.waitpid(proc.pid, os.WNOHANG)
	proc_list.append(proc.pid)
	return result
