# encodep.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: encodep.py,v 1.1 2003/09/25 17:31:45 mkennedy Exp $
#
# $Log: encodep.py,v $
# Revision 1.1  2003/09/25 17:31:45  mkennedy
# intial import
#
# Revision 1.1  2002/05/01 08:39:22  hacker
# Initial revision
#
#
##

from yahoodef import *
import struct

# new stuff (ymsg 9 packets)
def verify_server():
	return struct.pack("!4slhhll", "YMSG", 0x000b0000, 0, 0x4c, 0, 0)

def request_key(user):
	data = "1\xC0\x80%s\xC0\x80" % user
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x000b0000, len(data), 0x57, 0, 0, data)

def m9_login(user, key1, key2):
	data = "0\xC0\x80%s\xC0\x80%s\xC0\x80%s\xC0\x80%s\xC0\x80%s\xC0\x80%s\xC0\x80%s\xC0\x80%s\xC0\x80%s\xC0\x80" % (user, '6', key1, '96', key2, '2', user, '1', user)
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x000b0000, len(data), 0x54, 0x5a55aa55, 0, data)

def m9_ping(user, sessionID):
	data = "109\xC0\x80%s\xC0\x80" % user
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x000b0000, len(data), 0xa1, 0, sessionID, data)

def m9_comment(user, room, text, sessionID):
	data = '1%s%s%s104%s%s%s117%s%s%s124%s%s%s' % (
			'\xC0\x80', user, '\xC0\x80',
			'\xC0\x80', room, '\xC0\x80',
			'\xC0\x80', text, '\xC0\x80',
			'\xC0\x80', '1', '\xC0\x80')
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x000b0000, len(data), 0xa8, 0, sessionID, data)

def m9_emote(user, room, text, sessionID):
	data = '1%s%s%s104%s%s%s117%s%s%s124%s%s%s' % (
			'\xC0\x80', user, '\xC0\x80',
			'\xC0\x80', room, '\xC0\x80',
			'\xC0\x80', text, '\xC0\x80',
			'\xC0\x80', '2', '\xC0\x80')
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x000b0000, len(data), 0xa8, 0, sessionID, data)

def m9_thought(user, room, text, sessionID):
	data = '1%s%s%s104%s%s%s117%s. o O ( %s )%s124%s%s%s' % (
			'\xC0\x80', user, '\xC0\x80',
			'\xC0\x80', room, '\xC0\x80',
			'\xC0\x80', text, '\xC0\x80',
			'\xC0\x80', '3', '\xC0\x80')
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x000b0000, len(data), 0xa8, 0, sessionID, data)

def m9_addbuddy(user, friend, sessionID):
	data = '1%s%s%s7%s%s%s65%s%s%s14%s%s%s' % (
			'\xC0\x80', user, '\xC0\x80',
			'\xC0\x80', friend, '\xC0\x80',
			'\xC0\x80', "Chat Friends", '\xC0\x80',
			'\xC0\x80', "You're cool :))", '\xC0\x80')
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x900c800, len(data), 0x83, 0, sessionID, data)

def m9_join(user, room, sessionID):
	data = '1%s%s%s62%s%s%s104%s%s%s129%s%s%s' % (
			'\xC0\x80', user, '\xC0\x80',
			'\xC0\x80', "2", '\xC0\x80',
			'\xC0\x80', room, '\xC0\x80',
			'\xC0\x80', "0", '\xC0\x80')
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x000b0000, len(data), 0x98, 0, sessionID, data)

def m9_online(user,  sessionID):
	data = '109%s%s%s1%s%s%s6%s%s%s' % (
			'\xC0\x80', user, '\xC0\x80',
			'\xC0\x80', user, '\xC0\x80',
			'\xC0\x80', "abcde", '\xC0\x80')
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x000b0000, len(data), 0x96, 0, sessionID, data)

def m9_goAway(text, sessionID):
	data = '%s\xC0\x80%s\xC0\x80%s\xC0\x80%s\xC0\x80%s\xC0\x80%s' % ("10", "99", "19", text, "47", "0")
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x70000, len(data), 0x03, 0, sessionID, data)

def m9_goBack(sessionID):
	fmt = "!4slhhll"
	return struct.pack(fmt, "YMSG", 0x70000, 0, 0x04, 0, sessionID)

def m9_pm(user, otheruser, text, sessionID):
	data = ''.join([
		'%s%s%s%s' % ("1", DELIM, user, DELIM),
		'%s%s%s%s' % ("5", DELIM, otheruser, DELIM),
		'%s%s%s%s' % ("14", DELIM, text, DELIM),
		'%s%s%s%s' % ("97", DELIM, "1", DELIM),
		'%s%s%s%s' % ("63", DELIM, ";0", DELIM),
		'%s%s%s%s' % ("64", DELIM, "0", DELIM)])
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x000b0000, len(data), 0x06, 0x5a55aa55, sessionID, data)

def m9_goto(user, otheruser, sessionID):
	data = ''.join([
		'%s%s%s%s' % ("109", DELIM, otheruser, DELIM),
		'%s%s%s%s' % ("1", DELIM, user, DELIM),
		'%s%s%s%s' % ("62", DELIM, "2", DELIM)])
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x000b0000, len(data), 0x97, 0, sessionID, data)

def m9_logout(user, sessionID):
	data = "%s%s%s%s" % ("1", DELIM, user, DELIM)
	fmt = "!4slhhll%ss" % len(data)
	return struct.pack(fmt, "YMSG", 0x000b0000, len(data), 0xa0, 0, sessionID, data)

# end of new stuff (ymsg 9 packets)
def do(d):
	if d.has_key('type'):
		t = d['type']
		if t == 'comment' and d.has_key('text'):
			return m9_comment(d['user'], d['room'], d['text'], d['sessionID'])
			#return comment(d['text'])
		elif t == 'pm' and d.has_key('user') and d.has_key('sessionID') and d.has_key('otheruser') and d.has_key('text'):
			return m9_pm(d['user'], d['otheruser'], d['text'], d['sessionID'])
		elif t == 'emote' and d.has_key('text'):
			return m9_emote(d['user'], d['room'], d['text'], d['sessionID'])
			#return emote(d['text'])
		elif t == 'thought' and d.has_key('text'):
			return m9_comment(d['user'], d['room'], d['text'], d['sessionID'])
			#return thought(d['text'])
		elif t == 'away' and d.has_key('text'):
			return m9_goAway( d['text'], d['sessionID'])
		elif t == 'back':
			return m9_goBack(d['sessionID'])
		elif t == 'join' and d.has_key('room'):
			return m9_join(d['user'], d['room'], d['sessionID'])
			#return join(d['room'])
		elif t == 'ping':
			return m9_ping(d['user'], d['sessionID'])
		elif t == 'challenge':
			return request_key(d['user'])
		elif t == 'logout':
			return m9_logout(d['user'], d['sessionID'])
		elif t == 'addbuddy':
			return m9_addbuddy(d['user'], d['friend'], d['sessionID'])
		elif t == 'login':
			return m9_login(d['user'], d['key1'], d['key2'])
			#return login(d['user'], d['cookie'])
		elif t == 'online':
			return m9_online(d['user'], d['sessionID'])
		elif t == 'goto':
			return m9_goto(d['user'], d['otheruser'], d['sessionID'])

