# yahoodef.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: yahoodef.py,v 1.2 2005/11/27 20:52:46 mkennedy Exp $

import re

# yahoo chat servers
CS5 = ('cs57.msg.sc5.yahoo.com', 8001)
CS6 = ('cs54.msg.sc5.yahoo.com', 8001)
CS7 = ('cs55.msg.sc5.yahoo.com', 8001)
CS8 = ('cs19.msg.sc5.yahoo.com', 8001)

# CS5 = ('cs5.chat.yahoo.com', 8001)
# CS6 = ('cs6.chat.yahoo.com', 8001)
# CS7 = ('cs7.chat.yahoo.com', 8001)
# CS8 = ('cs8.chat.yahoo.com', 8001)

# packet types. not comprehensive, just those i care to read
LOGIN = 0x01L
LOGOUT = 0x02L

ENTER = 0x11L
EXIT = 0x12L
AWAY = 0x21L

COMMENT = 0x41L
EMOTE = 0x43L
PM = 0x45L
THOUGHT = 0x42L

# field delimiters
DELIM = '\xC0\x80'
NICKDELIM = re.compile(r'\x02.\x02\x20\x02\x30\x02\x30\x02\x20\x01?')

AWAYMESG = {
	'0': 'is back',
	'1': 'is away (be right back)',
	'2': 'is away (busy)',
	'3': 'is away (not at home)',
	'4': 'is away (not at my desk)',
	'5': 'is away (not in the office)',
	'6': 'is away (on the phone)',
	'7': 'is away (on vacation)',
	'8': 'is away (out to lunch)',
	'9': 'is away (stepped out)',
#  '10' custom away message
	'11': 'is away (auto away)'
}

# misc
HEADERLEN = 16

