# babelizer.py - API for simple access to babelfish.altavista.com.
#                Requires python 2.0 or better.
#
#                       )><((@> BaBeLfIsH <@))><( 
# 
#
# Hacked back into existence by sl4ckw4re_syst3m - wasn't working because altavista babelfish
# page has changed and the url was different from what was in here too, after a little tinkering
# it is working once more   
#
#Tue Apr 20 09:12:51 BST 2004 - sl4ckw4re_syst3m modified regex's 
# altavista changed babelfish again site (minimal changes but enough to break) 
# just added a regex and an extra variable
# ...it is working once more   

import re, string, urllib

"""
Various patterns I have encountered in looking for the babelfish result.
We try each of them in turn, based on the relative number of times I've
seen each of these patterns.  $1.00 to anyone who can provide a heuristic
for knowing which one to use.   This includes AltaVista employees.
"""

__where = [ re.compile(r'name=\"q\">([^<]*)'),
            re.compile(r'td bgcolor=white>([^<]*)'),
            re.compile(r'<\/strong><br>([^<]*)'),
            re.compile(r'<td bgcolor=white class=s><div style=padding:10px;>([^<]*)'),
	    re.compile(r'<input type=hidden name=\"q\" value=\"([^>]*)\"'),
          ]


__languages = { 'english'   : 'en',
                'french'    : 'fr',
                'spanish'   : 'es',
                'german'    : 'de',
                'italian'   : 'it',
                'portugese' : 'pt',
              }

"""
  All of the available language names.
"""
available_languages = [ x.title() for x in __languages.keys() ]

"""
  Calling translate() or babelize() can raise a BabelizerError
"""
class BabelizerError(Exception):
    pass

class LanguageNotAvailableError(BabelizerError):
    pass
class BabelfishChangedError(BabelizerError):
    pass
class BabelizerIOError(BabelizerError):
    pass

def clean(text):
    return ' '.join(string.replace(text.strip(), "\n", ' ').split())

def translate(phrase, from_lang, to_lang):
    phrase = clean(phrase)
    try:
        from_code = __languages[from_lang.lower()]
        to_code = __languages[to_lang.lower()]
    except KeyError, lang:
        raise LanguageNotAvailableError(lang)
    
    params = urllib.urlencode( { 'BabelFishFrontPage' : 'yes',
                                 'doit' : 'done',
                                 'tt' : 'urltext',
                                 'urltext' : phrase,
                                 'lp' : from_code + '_' + to_code } )
#    params = urllib.urlencode( { 'intl' : '1',
#                                 'doit' : 'done',
#                                 'tt' : 'urltext',
#                                 'urltext' : phrase,
#                                 'lp' : from_code + '_' + to_code } )
    try:
        response = urllib.urlopen('http://babelfish.altavista.com/babelfish/tr', params)
    except IOError, what:
        raise BabelizerIOError("Couldn't talk to server: %s" % what)
    except:
        print "Unexpected error:", sys.exc_info()[0]

    html = response.read()

    #print html

    for regex in __where:
        match = regex.search(html)
        if match: break
    if not match: raise BabelfishChangedError("Can't recognize translated string.")
    return clean(match.group(1))

def babelize(phrase, from_language, through_language, limit = 12, callback = None):
    phrase = clean(phrase)
    seen = { phrase: 1 }
    if callback:
        callback(phrase)
    else:
        results = [ phrase ]
    flip = { from_language: through_language, through_language: from_language }
    next = from_language
    for i in range(limit):
        phrase = translate(phrase, next, flip[next])
        if seen.has_key(phrase): break
        seen[phrase] = 1
        if callback:
            callback(phrase)
        else:
            results.append(phrase)
        next = flip[next]
    if not callback: return results

if __name__ == '__main__':
    import sys
    def printer(x):
        print x
        sys.stdout.flush();

    
    babelize("I won't take that sort of treatment from you, or from your doggie!",
             'english', 'french', callback = printer)
