# cmdhelp.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: cmdhelp.py,v 1.3 2005/11/27 20:52:46 mkennedy Exp $


join = """/join or /j

	Allows one to join public chat room throughout the yahoo messenger service.

syntax: /join <room>

example: /join programming:1
example: /j california:1"""

ignore = """/i or /ignore or /iv or /ignore* or /i* or /iv*

	Silent (/i) or vocal (/iv) ignores create an "ignore" file storing unwanted trash, bots and just plain lamer usernames you dont EVER want to see again. Ignored usernames are stored within a plain file stored in: ~/.curphoo/ignore --- You can add an already existing "ignore" file to ~/.curphoo/ if you have one from a prior version of curphoo or other *nix chat client. An example of an ignore file you can place within the ~/.curphoo/ directory can be found here: 

 * http://edge-op.org/grouch/ignore

syntax: /ignore <user>
  Where <user> is a Yahoo! I.D. you want to banish to the iggy file

example: /i james_kelly
example: /ignore james_kelly
  The above examples silently places james_kelly on youre ignore list

example: /iv james_kelly
  Using this option would tell the room you have just placed james_kelly on iggy! You can edit the output of this verbal ignore by creating a "ignoremsg" file within ~/.curphoo/ -- The "ignoremsg" file can contain words or ascii art...

example: /ignore james_kelly.*
  Ignores all instances of james_kelly**** -- ex. james_kelly01 - james_kelly100000

example: /ignore* hax0r1 b4dCumPany YoWmAaaAmA etc etc etc
example: /i* hax0r1 b4dCumPany YoWmAaaAmA etc etc etc
example: /iv* hax0r1 b4dCumPany YoWmAaaAmA etc etc etc
  The above examples allow you to ignore multiple users at once.

Remember that running the above options a second time on a lamers username will unignore that user and remove it from youre "ignore list.

To list all users on youre "ignore" list that are currently in the chatroom use /i or /iv / or /ignore by itself."""

buddy = """/buddy or /b

	Gives friends and other Yahoo! members pm privileges.

syntax: /buddy <user>
  <user> is the Yahoo! ID of the buddy you want to be able to PM you whenever youre signed onto Yahoo!

example: /buddy the_cpu_fan
  Doing this would accept all private messages from the one and only... the_cpu_fan --- the creator of curphoo. Hail the_cpu_fan when you see him online.

example: /buddy
  This will list all the buddies on youre buddy list located inside ~/.curphoo/ directory"""

ybuddy = """/ybuddy or /yb

	This is a NEW feature added by the_cpu_fan which allows one to be notified when one of youre buddies logs on or off the Yahoo! service. This option is different than /buddy as this option is global instead of local. This feature adds a buddy to youre actual Yahoo! Messenger buddy list instead of the file located inside ~/.curphoo/...

syntax: /ybuddy <user>
  <user> is the Yahoo! ID of the person you want to add to youre official Yahoo! Messenger buddy list... remember this list follows you whenever you log onto the Yahoo! Messenger Service.

example: /yb the_cpu_fan
example: /ybuddy lam0idz
  Will add these Yahoo! ID's onto youre messenger buddy list and will tell you when either the_cpu_fan or lam0idz log on / off of the service

example: /yb
example: /ybuddy
  Using these commands by themselves lists the buddies that are online @ the moment and are NOT using the invisible option. If youre buddy is NOT online then they will NOT show up when you use this option."""

clear = """/clear or /cls

	This option clears the screen and leaves you with a clean slate so to speak. Useful when you need to get rid of something you dotn want to read on screen.

syntax: /clear

example: /clear
example: /cls"""

think = """/think or /t

	. o 0 ( This cute option makes it look like what you type is within a bubble usually used in comic's to depict thinking )

syntax: /think {type something you are thinking}

example: /think i R_eally Hate stuck up 22 year OLd gnoMES_ from the UK
  If I were to use this option within chat... it would look like this:

	*<lam0idz> . o 0 ( i R_eally Hate stuck up 22 year OLd gnoMES_ from the UK. )"""

quit = """/quit or /q

	Allows one to escape the clutches of the Yahoo! chat service by quitting the elite and never duplicated curphoo chat client...

syntax: /quit {message}
  Where {message} is optional and can be anything you want to let everyone know before the elite curphoo chat client actually logs youre username out.

example: /quit im out now so PEAAAAAACE!"""

emote = """: or /me

	Yes... once again life has been made exciting by the new protocol change our wonderful leader the_cpu_fan implemented for the new curphoo chat client. Emotes provide a little excitement to the daily drag of Yahoo! life... a Yahoo! life without emotes is no life at all!

syntax: /me <message>

example: /me is a *pimp*
  If Yahoo! ID "indigo_corr" used the emote option above it would look like this in the chatroom:

	* indigo_corr is a *pimp*

example: :is *dying*
  If Yahoo! ID "duralinux" used the emote option and message above it would look like this in the chatroom:

	* duralinux is *dying*"""

tell = """/tell or /msg or /m

	What would Yahoo! life be without the ability to send private messages to harrass and enamor other users of the Yahoo! messenger service? This nifty features adds another level of communication with people outside of the current chatroom that youre in as well as private communication with a Yahoo! member inside the current chatroom youre stationed in.

syntax: /tell <user> {message}
  Where
    <user> -- the name of the chatter you want to PM.
       {message} -- whatever you want to say to the chatter in private.

example: /tell mountain_penquin the features U contributed 2 curphoo rock dude!
example: /msg cpu_melt_down hia kan yew proveye lennox halp plz?!?
example: /m edge-op wanna get together and listen to the new Britney Spears album and bop our heads later dude?

Once you have PM'ed a user ONCE ... you can use "#<TAB>" to message the same user again... lets say for instance that I want to have a conversation in private with the_cpu_fan... i would first do this:

	* /tell the_cpu_fan sup dude!

>From that point forward if I wanted to PM or respond to his PM's I would simply just type:

	* #<TAB KEY ON KEYBOARD> hahaha yeah you dont frikkin say?

Note from the_cpu_fan: For those that find typing /tell something something something a tad tedious I've added #<TAB> support. This looks at youre last /tell command string and puts that string on the input box excluding the actual message.

See /help buddy"""

shellexec = """!

	Any command that starts with '!' is interpreted as a shell command and the output of the command is then printed AND sent into the chatroom for the world to see youre command chops.

syntax: !<sh command>

example: !df -Th

example: !uptime"""

localexec = """!!

	Any command starting with '!!' is interpreted as a shell command whose output will be printed inside the chatroom BUT WILL NOT be sent to the chat room. Consider it a private shell exec where only YOU can see it. You should use this option first if you are unsure of the outcome of youre shell command... as you will probably be iggied for being a lamer if youre command produces undesirable effects of spamming the room with giberish.

syntax: !!<sh command>

example: !!ls -alF"""

hilite_user = """/hilite-user or /hu

	Highlights chatroom posts of the user you specify when you use this feature. 

syntax: /hu <user>
  Where <user> is the name of the chatter whose chatroom posts you want highlighted.

example: /hilite-user the_cpu_fan
  highlights the_cpu_fan's chatroom posts.

example: /hu imparcival
  highlights IMParcival's posts.

To list all users on highlight type: /hu
To remove a user from the highlight list type: /hu <user>"""

hilite_string = """/hilite-string or /hs

	Highlights any post where a regular expression matches.

syntax: /hilite-string <regex>

example: /hs \*dying\*
  highlights any post where the string "*dying*" appears

To remove a regex from the highlight list type: /hilite-user <regex>"""

slash = """/ or /users
List all users"""

uptime = """/uptime or /up
	
	Long gone are the days when our uptime was only a matter of minutes... let the world know just how elite and kick ass youre new curphoo chat client is by showing everyone that yes... stable chat clients do exist!	

syntax: /up[time]"""

ver = """/v or /ver or /version

	Shows all where you got your copy of curphoo from.

syntax: /v"""

away = """/away or /a

	Tells everyone you're away.

syntax: /away [excuse]

example: /away

example: /away off to lunch"""

back = """/back

	Tell everyone you've returned.

syntax: /back"""

goto = """/goto

	Follow a user, wherever he may go.

syntax: /goto <user>

example: /goto the_cpu_fan"""

openurl = """/openurl

	Loads a url in a new web browser window. The url can be
given as an argument to the /openurl or if no arguments
are given the url used is the most recent url seen in
the chat window.

syntax: /openurl [url]

example: /openurl http://slashdot.org

example: /openurl http://bluelein.com

example: /openurl
 The above example will open the last URL a user has posted inside the chatroom """

pm = """/pm

	This feature toggles between:
	
	* Accepting all private messages -- you will receive PM's from anyone and everyone that feels like bugging you. Use this feature when you DONT want to add someone to youre /buddy list... 

	* Accepting private messages from friends -- only people you will receive PM's from will be people you have used the '/buddy <user>' command with... this means that only you're closest buddies can PM you... understand you will NOT receive PM's from ANYONE that is NOT '/buddy <user>'... you will not receive pm's from people that you have '/yb <user>'... 

syntax: /pm

example: /pm

See /help buddy or /help ybuddy for more information"""

uinfo = """/uinfo

	User info will show you the chatter's time, last commend and comment count. Please note this feature will ONLY return information from chatters that are within the same chatroom you are currently a part of.

syntax: /uinfo <user>
  where <user> is a Yahoo! ID within the same chatroom youre in that you would like to query.

example: /uinfo mountainpenguin
  using /uinfo on the user mountainpenguin produced this result:
*** User Info : [mountainpenguin]
chat time: 00:03.24
last comment: javatype: yea.. but 1.1 is out now.
comment count: 6"""

color = """/color

	mountainpenguin added a customizable color profile. The color settings are stored at ~/.curphoo/color and available colors are:

	*black
	*red
	*green
	*yellow
	*blue
	*megenta
	*cyan
	*white

syntax: /color
  will show all color profiles available for editing

example: /color set PROFILENAME COLOR
  where PROFILENAME is name of types of messages found using /color
    where COLOR is one of the eight colors available
Once done with you're custom color setup you must save by using either:
	* /quit
	* /color save

example: /color load
  will read from ~/.curphoo/color
    this is useful if ~/.curphoo/color is modified with a text editor... you just save youre changes and then use the above command and you dont have to exit and re-enter.

example: /color save
  will save changes made within chat screen to ~/.curphoo/color"""

mute = """/mute

	will ignore user temporarily... this option will reset after a set amount of seconds or will reset after you /quit... this option differs from /ignore as it is NOT a permanent IGNORE. This option is handy for reg's that just get out of hand for a little bit and you need to gag them for a little bit... 

syntax: /mute <user>
  where <user> is a Yahoo! ID

example: /mute li1_bastard
  This will put the user li1_bastard on ignore until I exit the room... I will then be able to see his type when I re-enter the room... 

Using /mute <user> again will un-mute user"""

load = """/load

	loads the following files contained in ~/.curphoo/
	* color
	* command
	* ignore
	* ignoremsg

This useful option added by mountainpenguin ends the days of having to exit and re-enter each time you made a change to any of the above files.

syntax: /load [file]
  where [file] is either color, command, ignore, ignoremsg contained within ~/.curphoo/

example: /load color
  will load changes made to ~/.curphoo/color -- for more information please see /help color

example: /load command
  will load changes made to ~/.curphoo/commands -- for more information please see /help command

example: /load ignore
  will load changes made to ~/.curphoo/ignore  -- for more information on the 'ignore' file see /help ignore

example: /ignoremsg
  will load changes made to ~/.curphoo/ignoremsg  -- loads a custom ignore message to be used with vocal iggy -- for more information on the 'ignoremsg' file please see /help ignoremsg"""

openprofile = """/openprofile

	will open user's profile page in the form of:
	
	* http://profiles.yahoo.com/*****

syntax: /openurl <user>
  where <user> is the Yahoo! ID you want to profile.

example: /openprofile lam0idz
  using the above example would take you directly to my profile by opening up the browser in youre path and go to URL: http://profiles.yahoo.com/lam0idz """

regex = """/regex

	will add the regex to the regex ignore list

syntax: /regex <regex>
  where <regex> is the regex filter.
example: /regex \w{1,}@hotmail\.com """

command = """ ~/.curphoo/commands

	The 'command' file is where you add custom emotes, shell commands and blocks of text you find youreself repeating over and over. You can use the /load command to instantly load the changes you have made to this file... the following is an example of how to build a custom 'command' file:

	* cd ~/.curphoo
	* vi commands

You can of course use youre favorite text editor to create this file. One can create three different types of commands inside this file and they are:

	* regular comment type commands
	* sh type commands
	* emote type commands

syntax: /<commands name> {{username}}
  where <commands name> is the name given to any of the above three types found within the ~/.curphoo/commands file.
    where {{username}} is optional if you have added a '%s' into any of the above three command types. Using '%s' will direct the output towards the username you specify.

Here is a condensed version of my 'commands file':

----- everything below this line belongs in ~/.curphoo/commands -----
# Start of lam0idz commands file

# prepending any of the following three command types with a '/'
# regular comment type commands
:xp
Wintendo XP(loit) - Microslut 1976-2002 - MS-DOS, 3.1 95 98SE ME NT - XPensive, 
Non-Functional & Insecure - 666+ remote holes in the default install, in nearly 
27 years!
# sh type commands
!tune
xmmsshow
!kill
killall -9 xmms
!mo
mozilla
# emote type commands
::winz
uname -a       Lindows Wintendo 2.4.20-dev #666 Fri May 31 01:25:31 PDT 2002 i68
6 PentiumIV - lam0idz
::plz
disinfects %s from the "plz" virus --- you better get cured dammit or I shall ha
ve to IgGgGGgGY U! [-( hmph! [-(

# End of lam0idz 'commands file
----- everything ABOVE this line belongs in ~/.curphoo/commands -----

example: /mo
  this shell type command will produce nothing in the room, but will call up mozilla instead of me having to type out !!mozilla in the room OR having to use the mouse to call it up. Using commands like these save you keystrokes... this command alone saves me seven keystrokes!

example: /kill
  this shell type command kills the crash loving xmms by saving me a few keystrokes... see how this can be kind of handy now? I just have to type '/kill' instead of '!killall -9 xmms' within the chatroom. 

example: /plz li1_bastard
  this emote type command will produce the following output into the chatroom:

* lam0idz disinfects li1_bastard from the "plz" virus --- you better get cured
  dammit or I shall have to IgGgGGgGY U! [-( hmph! [-(

Using '%s' within any of the following command types:
	 
	* regular command type
	* emote command type	

will produce the "username" effect... by this I mean you can direct the emote to another user instead of using an emote as a way to describe actions you do onto yourself... you can describe actions you are doing towards another user... 

Play with the file and youre Yahoo! experience will be a bit more productive and fun!"""

ignoremsg = """ ~/.curphoo/ignoremsg

	The 'ignoremsg' file is where you enter a message to be sent out whenever you use the following commands on a user:

	* /iv <user>
	* /igv <user>
	* /ignorev <user>

You can edit this file to youre liking using '%s' within the file to direct the ignore message to the intended recipient of the permanent and vocal ignore you are about to give them.

Since I have gotten used to ignoring with the /iv option I have made a smaller ignoremsg file so as not to annoy the regulars. My ignoremsg file consists of the following:

----- below this line belongs in ~/.curphoo/ignoremsg -----

*** ATTENTION %s:  It's time for you to go away ***

----- above this line belongs in ~/.curphoo/ignoremsg -----

Lets say you are creating this file as you read this in another xterm... before you would have to /quit curphoo then re-enter for the file to take effect, but mountainpenguin has been working his little flippers off in the cold poles to bring us a nifty new feature which allows us to load the new ignoremsg file without having to exit! After saving the file please run the following command within the chatroom:

	* load command

This means you can change the file and then load it over and over again while testing it within the chatroom to find the perfect message you want to give that pesky person you want to ignore vocally... of course you can find more information about this command by looking here: /help load

example: /iv YouReMommA 
 this will produce the following message onto the user r_holmes_uk and will grab the vocal ignore message from the file ~/.curphoo/ignoremsg 

* <lam0idz> *** annoyingtroll will be ignored

For more information on: 

	* /load
	* /iv

features please consult the following: /help load OR /help ignore"""

babelfish = """Babelfish Language Translation engine. 
curphoo is now capable of on-the-fly language tranlsation via altavista babelfish. 
Currently available options are: 

/french  (/fr)
/german  (/ge)
/spanish (/spa)
/portugese (/po)
/italian (/it)

example: /french text goes here
Output to room:  le texte va ici

/tr or /translate: 
these are used to translate everything one particular user says. 
by default it converts from french to english. 
eg: 
/tr sl4ckw4re_syst3m
*** sl4ckw4re_syst3m now added to list of users to translate

you can modify the languages its translating between using two options:

/babel_from English     sets the base language to English
/babel_to  German        sets the language to translate to to German

valid options are same as above - french/german/spanish/portugese/italian

"""


help = """Curphoo Commands Help File -- (c) 2002 Alex Mercader <the_cpu_fan>
/pm				    -- toggles PM privileges
/color				    -- color customizable items
/mute <user>			    -- current chat session <user> mute 
/load <file>			    -- please see / help load
/openprofile <user>		    -- opens <user>'s Yahoo! profile
/openurl <url>			    -- opens URL or last chat URL
/uinfo <user>			    -- chatroom activity of <user>
/join <room>                        -- join a room
/quit [message]                     -- quit chat session
/ignore <user>                      -- ignore a user
/ignore* <user1> [user2] ...        -- ignore multiple users
/buddy <user>                       -- give a user pm privileges
/ybuddy <user>                      -- add a user to your Yahoo buddy list
/tell <user> [!]<message>           -- send user a private message
/msg  <user> [!]<message>           -- send user a private message
/hs <regex>                         -- highlight any post where regex matches
/hu <user>                          -- highlight user's posts
/uptime                             -- tell everyone curphoo is unbootable
/ver                                -- tell everyone you're a champ
/                                   -- list all users
/users                              -- list all users
/away [excuse]                      -- tell everyone you're away
/back                               -- tell everyone you're back
/goto <user>                        -- follow a user into another room
/regex <regex>                      -- ignore lines with regex
! <sh command>                      -- show all you've got sh fu
!! <sh command>                     -- show yourself your sh fu
:<message>                          -- emotes
#<TAB>				    -- ease PM usage -- see /help tell
ignoremsg			    -- customizable ignore ascii message  
commands			    -- customizable reg., emote & sh commands
credits				    -- props to the_cpu_fan and contributors
babelfish                           -- language translation on the fly
type /help <command> for more."""
helpd = {
        '/away': away,
	'/uinfo': uinfo,
	'uinfo': uinfo,
	'/#<TAB>': tell,
	'#<TAB>': tell,
	'/color': color,
	'color': color,
	'/mute': mute,
	'mute': mute,
	'/load': load,
	'load': load,
	'/openprofile': openprofile,
	'openprofile': openprofile,
	'ignoremsg': ignoremsg,
	'/ignoremsg': ignoremsg,
	'commands': command,
	'command': command,
	'/commands': command,
	'/command': command,
        'away': away,
        '/back': back,
        'back': back,
        '/goto': goto,
        'goto': goto,
        '/clear': clear,
        'clear': clear,
        '/think': think,
        'think': think,
        '/join': join,
        'join': join,
        '/quit': quit,
        'quit': quit,
        '/ignore': ignore,
        'ignore': ignore,
        '/buddy': buddy,
        'buddy': buddy,
        '/ybuddy': ybuddy,
        'ybuddy': ybuddy,
        '/tell': tell,
        'tell': tell,
        '/msg': tell,
        'msg': tell,
        '/openurl': openurl,
        'openurl': openurl,
        '/': slash,
        '/users': slash,
        'users': slash,
        '/hs': hilite_string,
        'hs': hilite_string,
        '/hu': hilite_user,
        'hu': hilite_user,
        '/ver': ver,
        'ver': ver,
        '/uptime': uptime,
        'uptime': uptime,
        'babelfish': babelfish,
        '!': shellexec,
        '!!': localexec,
        '/me': emote,
        'me': emote,
        ':': emote,
	'/pm': pm,
	'pm': pm,
	'/regex': regex,
	'regex' : regex
}

