# output.py
# Copyright 2002 Alex Mercader <alex.mercader@iinet.net.au>
#
# This file is part of Curphoo.
#
# Curphoo is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Curphoo is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Curphoo; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: output.py,v 1.5 2006/08/14 16:48:18 BoW4IamTheBOFH Exp $

import curses
import time
import sys
import os
import re
import babelizer
#import copy

def wordwrap(win, text, indent=2):
	x = win.getyx()[1]
	mx = win.getmaxyx()[1]
	text = text.strip()
	if text.find('\n') != -1:
		if text.count('\n') == 1 and len(text) < (mx-x):
			text = text.replace('\n', ' ')
		wrap = text
	else:
		wrap = ''
		r = curses.COLS - x
		while len(text) > r:
			i = text[:r].rfind(' ')
			if i == -1:
				if text[:r-1].strip():
					wrap = "%s%s\n%s" % (wrap,text[:r-1],' '*indent)
				text = text[r-1:].lstrip()
			else:
				if text[:i].strip():
					wrap = "%s%s\n%s" % (wrap,text[:i],' '*indent)
				text = text[i:].lstrip()
			r = curses.COLS - indent
		else:
			wrap = "%s%s" % (wrap, text.strip())
	return wrap.rstrip()

def wordwrap_log(text, indent=2):
	x = 0
	mx = 80
	text = text.strip()
	if text.find('\n') != -1:
		if text.count('\n') == 1 and len(text) < (mx-x):
			text = text.replace('\n', ' ')
		wrap = text
	else:
		wrap = ''
		r = mx - x
		while len(text) > r:
			i = text[:r].rfind(' ')
			if i == -1:
				if text[:r-1].strip():
					wrap = "%s%s\n%s" % (wrap,text[:r-1],' '*indent)
				text = text[r-1:].lstrip()
			else:
				if text[:i].strip():
					wrap = "%s%s\n%s" % (wrap,text[:i],' '*indent)
				text = text[i:].lstrip()
			r = mx - indent
		else:
			wrap = "%s%s" % (wrap, text.strip())
	return wrap.rstrip()

def cmpfunc(x, y):
	res = 0
	a = x.lower()
	b = y.lower()
	if a < b: res = -1
	elif a > b: res = 1
	return res

def list_highliststring(win, l, color, header=''):
	win.addstr('%s (%s):' % (header, len(l)), curses.color_pair(color))
	take_nl(win)
	l.sort(cmpfunc)
	sl = []
	for e in l:
		sl.append('[%s]' % e)
	win.addstr(wordwrap(win, ' '.join(sl), 0), curses.color_pair(color))
	take_nl(win)

def list_highlightusers(win, sess, ul, color, header=''):
	show_list(win, sess, ul, color, header)

def list_babelusers(win, sess, ul, color, header=''):
	show_list(win, sess, ul, color, header)

def list_buddies(win, sess, ul, color, header=''):
	show_list(win, sess, ul, color, header)

def list_ignoredusers(win, sess, ul, color, header=''):
	show_list(win, sess, ul, color, header)

def list_uidregex(win, sess, ul, color, header=''):
	show_list(win, sess, ul, color, header)

def list_regex(win, sess, ul, color, header=''):
	show_list(win, sess, ul, color, header)

def list_excludeusers(win, sess, ul, color, header=''):
	show_list(win, sess, ul, color, header)

def show_list(win, sess, ul, color, header=''):
	win.addstr('%s (%s):' % (header, len(ul)), curses.color_pair(color)|curses.A_BOLD)
	take_nl(win)
#	ul.sort(cmpfunc)
	cols = (curses.COLS - 1) / 20 
	rows = len(ul) / cols
	if len(ul) % cols > 0:
		rows = rows + 1
	currentrow = 0
	while currentrow < rows:
		currentcol = 0
		while currentcol < cols:
			ulindex = (rows * currentcol) + currentrow
			if ulindex > len(ul) - 1:
				break
			if len(ul[ulindex]) > 18:
				u = ul[ulindex][0:16] + '..'
			else:
				u = ul[ulindex]
			win.addstr('%-18s' % u, curses.color_pair(color))
			if currentcol + 1 < cols:
				win.addstr('  ')
			currentcol = currentcol + 1
		take_nl(win)
		currentrow = currentrow + 1

def list_currentusers(win, sess, ulall, color, header=''):
	ul = []  # for storing user list minus ignored users
	for u in ulall:
		if not u in sess.ignores.keys():
			ul.append(u)
	win.addstr('%s (%s):' % (header, len(ul)), curses.color_pair(color)|curses.A_BOLD)
	take_nl(win)
	ul.sort(cmpfunc)
	cols = (curses.COLS - 1) / 20 
	rows = len(ul) / cols
	if len(ul) % cols > 0:
		rows = rows + 1
	currentrow = 0
	while currentrow < rows:
		currentcol = 0
		while currentcol < cols:
			ulindex = (rows * currentcol) + currentrow
			if ulindex > len(ul) - 1:
				break
			if len(ul[ulindex]) > 18:
				u = ul[ulindex][0:16] + '..'
			else:
				u = ul[ulindex]
			if u in sess.high:
				win.addstr('%-18s' % u, curses.color_pair(color)|curses.A_BOLD)
			else:
				win.addstr('%-18s' % u, curses.color_pair(color))
			if currentcol + 1 < cols:
				win.addstr('  ')
			currentcol = currentcol + 1
		take_nl(win)
		currentrow = currentrow + 1

def list_color(win, sess):
	win.addstr('Colour Info : ', curses.color_pair(sess.color['colorlist'])|curses.A_BOLD)
	take_nl(win)
	cl = sess.color.keys()
	cl.sort()
	colwidth = 26
	cols = (curses.COLS - 1) / colwidth
	rows = len(cl) / cols
	if len(cl) % cols > 0:
		rows = rows + 1
	currentrow = 0
	while currentrow < rows:
		currentcol = 0
		while currentcol < cols:
			clindex = (rows * currentcol) + currentrow
			if clindex > len(cl) - 1:
				break
			colorprofile = cl[clindex]
			win.addstr('%s = ' % colorprofile, curses.color_pair(sess.color['colorlist']))
			colorstring = sess.colorraw[cl[clindex]].upper()
			win.addstr('%s' % colorstring, curses.color_pair(sess.color[cl[clindex]]))
			spacelength = colwidth - (len(colorprofile) + len(colorstring) + 4)
			win.addstr(('%-' + str(spacelength) + 's') % '')
			currentcol = currentcol + 1
		take_nl(win)
		currentrow = currentrow + 1

def list_rc(win, sess):
	win.addstr('Current Settings : ', curses.color_pair(sess.color['rclist'])|curses.A_BOLD)
	take_nl(win)
	rc_list = []
	for k in sess.rc.keys():
		if (k in ['password', 'room', 'username']):
			continue
		rc_list.append(k)
	rc_list.sort()
	colwidth = 32
	cols = (curses.COLS - 1) / colwidth
	rows = len(rc_list) / cols
	if len(rc_list) % cols > 0:
		rows = rows + 1
	currentrow = 0
	while currentrow < rows:
		currentcol = 0
		while currentcol < cols:
			index = (rows * currentcol) + currentrow
			if index > len(rc_list) - 1:
				break
			k = rc_list[index]
			v = sess.rc[k]
			win.addstr('%s = %s' % (k, v), curses.color_pair(sess.color['rclist']))
			spacelength = colwidth - (len(k) + len(v) + 4)
			win.addstr(('%-' + str(spacelength) + 's') % '')
			currentcol = currentcol + 1
		take_nl(win)
		currentrow = currentrow + 1

def log_notice(win, sess, yes=1):
	if yes:
		win.addstr('*** ', curses.color_pair(sess.color['logstartnotice'])|curses.A_BOLD)
		win.addstr('Logging started.', curses.color_pair(sess.color['logstartnotice']))
		take_nl(win)
		if not sess.rc['scroll-logstartnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	else:
		win.addstr('*** ', curses.color_pair(sess.color['logendnotice'])|curses.A_BOLD)
		win.addstr('Logging stopped.', curses.color_pair(sess.color['logendnotice']))
		take_nl(win)
		if not sess.rc['scroll-logendnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)

def pm_notice(win, sess, user, yes=1):
	if yes:
		win.addstr('*** ', curses.color_pair(sess.color['pmonnotice'])|curses.A_BOLD)
		win.addstr('%s will be allowed to pm.' % user, curses.color_pair(sess.color['pmoffnotice']))
		take_nl(win)
		if not sess.rc['scroll-pmonnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	else:
		win.addstr('*** ', curses.color_pair(sess.color['pmoffnotice'])|curses.A_BOLD)
		win.addstr('%s will not be allowed to pm.' % user, curses.color_pair(sess.color['pmoffnotice']))
		take_nl(win)
		if not sess.rc['scroll-pmoffnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)

def buddy_notice(win, sess, user, yes=1):
	win.addstr('*** ', curses.color_pair(sess.color['newbuddynotice'])|curses.A_BOLD)
	win.addstr('You just made %s a Yahoo! buddy :)).' % user, curses.color_pair(sess.color['newbuddynotice']))
	take_nl(win)
	if not sess.rc['scroll-newbuddynotice'].upper() == 'Y':
		r = win.getyx()[0]
		win.move(r-1, 0)

def histr_notice(win, sess, hitext, yes=1):
	if yes:
		win.addstr('*** ', curses.color_pair(sess.color['highonnotice'])|curses.A_BOLD)
		win.addstr('comments containing the string %s will be highlighted.' % hitext, curses.color_pair(sess.color['highonnotice']))
		take_nl(win)
		if not sess.rc['scroll-highonnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	else:
		win.addstr('*** ', curses.color_pair(sess.color['highoffnotice'])|curses.A_BOLD)
		win.addstr('removed %s from list of strings to highlight.' % hitext, curses.color_pair(sess.color['highoffnotice']))
		take_nl(win)
		if not sess.rc['scroll-highoffnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)

def hi_notice(win, sess, user, yes=1):
	if yes:
		win.addstr('*** ', curses.color_pair(sess.color['highonnotice'])|curses.A_BOLD)
		win.addstr('added %s to list of users to highlight.' % user, curses.color_pair(sess.color['highonnotice']))
		take_nl(win)
		if not sess.rc['scroll-highonnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	else:
		win.addstr('*** ', curses.color_pair(sess.color['highoffnotice'])|curses.A_BOLD)
		win.addstr('removed %s from list of users to highlight.' % user, curses.color_pair(sess.color['highoffnotice']))
		take_nl(win)
		if not sess.rc['scroll-highoffnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)

def autoignore_notice(win, sess, user, type):
	win.addstr('*** ', curses.color_pair(sess.color['autoignorenotice'])|curses.A_BOLD)
	win.addstr('%s is a %s and will be ignored.' % (user, type), curses.color_pair(sess.color['autoignorenotice']))
	take_nl(win)
	if not sess.rc['scroll-autoignorenotice'].upper() == 'Y':
		r = win.getyx()[0]
		win.move(r-1, 0)

def ignore_notice(win, sess, user, yes=1):
	if yes:
		win.addstr('*** ', curses.color_pair(sess.color['ignoreonnotice'])|curses.A_BOLD)
		win.addstr('%s will be ignored.' % user, curses.color_pair(sess.color['ignoreonnotice']))
		take_nl(win)
		if not sess.rc['scroll-ignoreonnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	else:
		win.addstr('*** ', curses.color_pair(sess.color['ignoreoffnotice'])|curses.A_BOLD)
		win.addstr('%s will not be ignored.' % user, curses.color_pair(sess.color['ignoreoffnotice']))
		take_nl(win)
		if not sess.rc['scroll-ignoreoffnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
#sl4ckw4re_syst3m
def translate_notice(win, sess, user, yes=1):
	if yes:
		win.addstr('*** ', curses.color_pair(sess.color['ignoreonnotice'])|curses.A_BOLD)
		win.addstr('translation engine on for %s ' % user, curses.color_pair(sess.color['ignoreonnotice']))
		take_nl(win)
		if not sess.rc['scroll-ignoreonnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	else:
		win.addstr('*** ', curses.color_pair(sess.color['ignoreoffnotice'])|curses.A_BOLD)
		win.addstr('translation engine off for %s.' % user, curses.color_pair(sess.color['ignoreoffnotice']))
		take_nl(win)
		if not sess.rc['scroll-ignoreoffnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)


def mute_notice(win, sess, user, yes=1):
	if yes:
		win.addstr('*** ', curses.color_pair(sess.color['muteonnotice'])|curses.A_BOLD)
		win.addstr('%s will be muted.' % user, curses.color_pair(sess.color['muteonnotice']))
		take_nl(win)
		if not sess.rc['scroll-muteonnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	else:
		win.addstr('*** ', curses.color_pair(sess.color['muteoffnotice'])|curses.A_BOLD)
		win.addstr('%s will not be muted.' % user, curses.color_pair(sess.color['muteoffnotice']))
		take_nl(win)
		if not sess.rc['scroll-muteoffnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)

def exclude_notice(win, sess, user, yes=1):
	if yes:
		win.addstr('*** ', curses.color_pair(sess.color['excludeonnotice'])|curses.A_BOLD)
		win.addstr('%s will be excluded from auto-ignore.' % user, curses.color_pair(sess.color['excludeonnotice']))
		take_nl(win)
		if not sess.rc['scroll-excludeonnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	else:
		win.addstr('*** ', curses.color_pair(sess.color['excludeoffnotice'])|curses.A_BOLD)
		win.addstr('%s will not be excluded from auto-ignore.' % user, curses.color_pair(sess.color['excludeoffnotice']))
		take_nl(win)
		if not sess.rc['scroll-excludeoffnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)

def shellcommand(win, sess, s):
	win.addstr('<%s> ' % sess.user, curses.color_pair(sess.color['shellcommand'])|curses.A_DIM)
	win.addstr(wordwrap(win, s), curses.color_pair(sess.color['shellcommand'])|curses.A_DIM)
	take_nl(win)

def mycomment(win, sess, text):
	win.addstr(sess.rc['style-mycomment'] % sess.user , curses.color_pair(sess.color['mycommentuser']))
	win.addstr(wordwrap(win, text), curses.color_pair(sess.color['mycommenttext']))
	take_nl(win)
	if sess.log:
		log({'type':'comment', 'user':sess.user, 'text':text}, sess.log)

def myemote(win, sess, text):
	win.addstr('* ', curses.color_pair(sess.color['myemotebullet']))
	win.addstr(wordwrap(win, '%s %s' %(sess.user, text)), curses.color_pair(sess.color['myemotetext']))
	take_nl(win)
	if sess.log:
		log({'type':'emote', 'user':sess.user, 'text':text}, sess.log)

def help(win, sess, s):
	win.addstr('*** HELP: ', curses.color_pair(sess.color['help'])|curses.A_BOLD)
	win.addstr(wordwrap(win, s), curses.color_pair(sess.color['help'])|curses.A_DIM)
	take_nl(win)

def blah(win, sess, s):
	win.addstr('*** BLAH: ', curses.color_pair(sess.color['openurl'])|curses.A_BOLD)
	win.addstr(wordwrap(win, s), curses.color_pair(sess.color['openurl'])|curses.A_DIM)
	take_nl(win)

def pm_status(win, sess, s, yes=1):
	if yes:
		win.addstr('*** ', curses.color_pair(sess.color['pmonnotice'])|curses.A_BOLD)
		win.addstr(wordwrap(win, s), curses.color_pair(sess.color['pmonnotice']))
		take_nl(win)
		if not sess.rc['scroll-pmnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	else:
		win.addstr('*** ', curses.color_pair(sess.color['pmoffnotice'])|curses.A_BOLD)
		win.addstr(wordwrap(win, s), curses.color_pair(sess.color['pmoffnotice']))
		take_nl(win)
		if not sess.rc['scroll-pmnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)

def pm_user(win, sess, user, s):
	win.addstr('<%s '  % sess.user, curses.color_pair(sess.color['pmnotice']))
	win.addstr('(%s)'  % user, curses.color_pair(sess.color['pmnotice'])|curses.A_DIM)
	win.addstr('> ', curses.color_pair(sess.color['pmnotice']))
	win.addstr(wordwrap(win, '%s' % s), curses.color_pair(sess.color['pmnotice']))
	take_nl(win)
	if sess.log:
		log({'type':'pm_local', 'user':user, 'text':s}, sess.log)

def take_nl(win):
	if win.getyx()[1]: win.addstr('\n')

def user_info(win, sess, user):
	if sess.userinfo.has_key(user):
		win.addstr('*** ', curses.color_pair(sess.color['userinfo'])|curses.A_BOLD)
		win.addstr('User Info : [%s] ' % user, curses.color_pair(sess.color['userinfo']))
		take_nl(win)
		if sess.userinfo[user].has_key('starttime'):
			u = time.time() - sess.userinfo[user]['starttime']
			u = int(u)
			days = u / (60*60*24)
			u = u % (60*60*24)
			hours = u / (60*60)
			u = u % (60*60)
			minutes = u / (60)
			seconds = u % 60
			timestr = ''
			if days:
				timestr = "%s %s, " % (days, days > 1 and 'days' or 'day')
			timestr = "%s%02d:%02d.%02d" % (timestr, hours, minutes, seconds)
			win.addstr('chat time: %s' % timestr, curses.color_pair(sess.color['userinfo']))
			take_nl(win)
		else:
			win.addstr('chat start time: longer than you\'ve chatted', curses.color_pair(sess.color['userinfo']))
			take_nl(win)
		if sess.userinfo[user].has_key('lastcomment'):
			win.addstr('last comment: %s' % sess.userinfo[user]['lastcomment'], curses.color_pair(sess.color['userinfo']))
			take_nl(win)
		if sess.userinfo[user].has_key('commentcount'):
			win.addstr('comment count: %s' % sess.userinfo[user]['commentcount'], curses.color_pair(sess.color['userinfo']))
			take_nl(win)
		if sess.userinfo[user].has_key('repeatcount'):
			win.addstr('repeat count: %s' % sess.userinfo[user]['repeatcount'], curses.color_pair(sess.color['userinfo']))
			take_nl(win)

def notify(win, sess, s):
	win.addstr('*** ', curses.color_pair(sess.color['defaultnotice'])|curses.A_BOLD)
	win.addstr(wordwrap(win, s), curses.color_pair(sess.color['defaultnotice']))
	take_nl(win)

def error(win, sess, s):
	win.addstr('!!! ', curses.color_pair(sess.color['errortext'])|curses.A_BOLD)
	win.addstr(wordwrap(win, s), curses.color_pair(sess.color['errortext']))
	take_nl(win)
	r = win.getyx()[0]
	win.move(r-1, 0)

def status(win, sess):
	if sess.afk:
		s = '[%s] %s@%s:%s' % (sess.time, sess.user, sess.server[:3], sess.room)
		s = '%s%s' % (s, ' '*(curses.COLS - (len(' -AWAY-') + len(s))))
		s = '%s%s' % (s, '-AWAY-')
	else:
		s = '[%s] %s@%s:%s C:%s I:%s B:%s' % (
			sess.time,
			sess.user,
			sess.server[:3],
			sess.room,
			len(sess.users),
			len(sess.ignores),
			len(sess.buddies))
	s = s[:curses.COLS-1]
	win.erase()
	win.addstr(s)
	win.noutrefresh()
	os.environ['TERM'] in ("rxvt" , "xterm", "xterm-color") and sys.stderr.write("\033]0;%s\a" % s)

def message(win, m, me, sess):
	t = m['type']
	if t == 'comment':
		# this block seems to be a dupe
		# NOTE:  may be missing logging
		if m['user'] == me:
			win.addstr('<%s> ' % m['user'], curses.color_pair(sess.color['mycommentuser']))
			win.addstr(wordwrap(win, m['text']), curses.color_pair(sess.color['mycommenttext']))
		else:
			highlight_on = 0
			if m['user'].lower() in sess.high or \
					[e for e in sess.highstr if re.search(r"%s" % e, m['text'], re.I)]:
				win.addstr(sess.rc['style-comment'] % m['user'], curses.color_pair(sess.color['highcommentuser'])|curses.A_BOLD)
				win.addstr(wordwrap(win, m['text']), curses.color_pair(sess.color['highcommenttext'])|curses.A_BOLD)
			else:
				win.addstr(sess.rc['style-comment'] % m['user'], curses.color_pair(sess.color['commentuser']))
				win.addstr(wordwrap(win, m['text']), curses.color_pair(sess.color['commenttext']))
			#sl4ckw4re_syst3m
			if m['user'].lower() in sess.babellist :
        			shcc =  babelizer.translate( m['text'], sess.babellang_from, sess.babellang_to )
				take_nl(win)
				win.addstr(wordwrap(win, '%s' % shcc), curses.color_pair(sess.color['highcommenttext']))

			
		take_nl(win)
	elif t == 'emote':
		if m['user'].lower() in sess.high or \
				[e for e in sess.highstr if re.search(r"%s" % e, m['text'], re.I)]:
			win.addstr('* ', curses.color_pair(sess.color['emotebullet'])|curses.A_BOLD)
			win.addstr(wordwrap(win, '%s %s' %(m['user'], m['text'])), curses.color_pair(sess.color['emotetext'])|curses.A_BOLD)
		else:
			win.addstr('* ', curses.color_pair(sess.color['emotebullet'])|curses.A_BOLD)
			win.addstr(wordwrap(win, '%s %s' %(m['user'], m['text'])))
		take_nl(win)
	elif t == 'away':
		win.addstr('*** ', curses.color_pair(sess.color['awayonnotice'])|curses.A_BOLD)
		win.addstr('Your buddy %s is away (%s)' % (m['user'], m['text']), curses.color_pair(sess.color['awayonnotice']))
		take_nl(win)
		if not sess.rc['scroll-awayonnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	elif t == 'back':
		win.addstr('*** ', curses.color_pair(sess.color['awayoffnotice'])|curses.A_BOLD)
		win.addstr('Your buddy %s is back' % m['user'], curses.color_pair(sess.color['awayoffnotice']))
		take_nl(win)
		if not sess.rc['scroll-awayoffnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	elif t == 'enter':
		win.addstr('>>> ', curses.color_pair(sess.color['userenternotice'])|curses.A_BOLD)
		win.addstr('%s has joined the room' % m['user'], curses.color_pair(sess.color['userenternotice']))
		take_nl(win)
		if not sess.rc['scroll-userenternotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	elif t == 'exit':
		win.addstr('<<< ', curses.color_pair(sess.color['userexitnotice'])|curses.A_BOLD)
		win.addstr('%s has left the room' % m['user'], curses.color_pair(sess.color['userexitnotice']))
		take_nl(win)
		if not sess.rc['scroll-userexitnotice'].upper() == 'Y':
			r = win.getyx()[0]
			win.move(r-1, 0)
	elif t == 'pm':
		win.addstr('<%s ' % m['user'], curses.color_pair(sess.color['pmnotice']))
		win.addstr('(%s)' % sess.user, curses.color_pair(sess.color['pmnotice'])|curses.A_DIM)
		win.addstr('> ', curses.color_pair(sess.color['pmnotice']))
		win.addstr(wordwrap(win, m['text']), curses.color_pair(sess.color['pmnotice']))
		take_nl(win)
	elif t == 'unknown':
		win.addstr('***', curses.color_pair(sess.color['pmnotice'])|curses.A_DIM)
		win.addstr(wordwrap(win, m['text']), curses.color_pair(sess.color['pmnotice'])|curses.A_DIM)
		take_nl(win)
	elif t == 'mail':
		if m['subject'] and m['sender'] and m['address']:
			win.addstr('***', curses.color_pair(sess.color['mailnotice'])|curses.A_BOLD)
			win.addstr(' You Have Mail!', curses.color_pair(sess.color['mailnotice']))
			take_nl(win)
			win.addstr('*** ', curses.color_pair(sess.color['mailnotice'])|curses.A_BOLD)
			win.addstr('%s From %s <%s>' % (m['subject'], m['sender'], m['address']), curses.color_pair(sess.color['mailnotice']))
			take_nl(win)
		elif m['num']:
			win.addstr('*** ', curses.color_pair(sess.color['mailnotice'])|curses.A_BOLD)
			win.addstr('You have %s unread message%s'%(m['num'], int(m['num']) > 1 and 's' or ''), curses.color_pair(sess.color['mailnotice'])|curses.A_BOLD)
			take_nl(win)
	elif t == 'logout':
		win.addstr('*** ', curses.color_pair(sess.color['logoutnotice'])|curses.A_BOLD)
		win.addstr('Logout successful.', curses.color_pair(sess.color['logoutnotice']))
		take_nl(win)
	elif t == 'login':
		win.addstr('*** ', curses.color_pair(sess.color['loginnotice'])|curses.A_BOLD)
		win.addstr('Login successful.', curses.color_pair(sess.color['loginnotice']))
		take_nl(win)
	elif t == 'buddyisonline':
		win.addstr('*** ', curses.color_pair(sess.color['buddyonnotice'])|curses.A_BOLD)
		if len(m['users']) == 1:
			win.addstr('Your buddy ', curses.color_pair(sess.color['buddyonnotice']))
			win.addstr(m['users'].pop(), curses.color_pair(sess.color['buddyonnotice']))
			win.addstr(' is online', curses.color_pair(sess.color['buddyonnotice']))
		else:
			win.addstr('Here are your online buddies: ', curses.color_pair(sess.color['buddylist']))
			text = wordwrap(win, '%s' % (', '.join(m['users'])))
			win.addstr(text, curses.color_pair(sess.color['buddylist']))
			#win.addstr(m['users'][0], curses.color_pair(1))
			#for e in m['users'][1:]:
			#	win.addstr(", ")
			#	win.addstr(e, curses.color_pair(1))
		take_nl(win)
	elif t == 'buddyisoffline':
		win.addstr('*** ', curses.color_pair(sess.color['buddyoffnotice'])|curses.A_BOLD)
		win.addstr('Your buddy ', curses.color_pair(sess.color['buddyoffnotice']))
		win.addstr(m['user'], curses.color_pair(sess.color['buddyoffnotice']))
		win.addstr(' is offline', curses.color_pair(sess.color['buddyoffnotice']))
		take_nl(win)
	elif t == 'join':
		win.addstr('*** ', curses.color_pair(sess.color['joinnotice'])|curses.A_BOLD)
		text = wordwrap(win, ' %s (%s)' % (m['room'], m['topic']))
		win.addstr(text, curses.color_pair(sess.color['joinnotice']))
		take_nl(win)
		list_currentusers(win, sess, m['users'], sess.color['userlist'], 'Users')

def log_time(f):
	if f:
		f.write(time.strftime('---[ %x %X ]---\n'))
		f.flush()

def log(m, f):
#	if (not f) or (m['type'] == 'crap'): return
	if (not f) : return
	t = m['type']
	timestamp = time.strftime("%T");
	try:
		if t == 'comment':
			s = '[%s] <%s> %s' % (timestamp, m['user'], m['text'])
			s = '%s\n' % wordwrap_log(s)
			f.write(s)
		elif t == 'emote':
			s = '[%s] * %s %s' % (timestamp, m['user'], m['text'])
			s = '%s\n' % wordwrap_log(s)
			f.write(s)
		elif t == 'crap':
			s = '[%s] CRAPLINE %s %s' % (timestamp, m['user'], m['text'])
			s = '%s\n' % wordwrap_log(s)
			f.write(s)
		elif t == 'away':
			s = '[%s] * %s %s' % (timestamp, m['user'], m['text'])
			s = '%s\n' % wordwrap_log(s)
			f.write(s)
		elif t == 'enter':
			f.write('*** %s has joined the room.\n' % m['user'])
		elif t == 'exit':
			f.write('*** %s has left the room.\n' % m['user'])
		elif t == 'pm':
			s = '[%s] *%s* %s' % (timestamp, m['user'], m['text'])
			s = '%s\n' % wordwrap_log(s)
			f.write(s)
		elif t == 'pm_local':
			s = '[%s] -> *%s* %s' % (timestamp, m['user'], m['text'])
			s = '%s\n' % wordwrap_log(s)
			f.write(s)
		elif t == 'logout':
			f.write('*** Logout successful.\n')
			f.write(time.strftime('---End Capture %x %X---\n'))
		elif t == 'login':
			f.write(time.strftime('---Start Capture %x %X---\n'))
			f.write('*** Login successful.\n')
		elif t == 'join':
			s = '%s\n' % wordwrap_log('*** %s (%s)' % (m['room'], m['topic']))
			f.write(s)
			s = '%s\n' % wordwrap_log('*** Users: %s' % ', '.join(m['users']))
			f.write(s)
		f.flush()
	except IOError:
		pass

def logrotate(f):
	if (not f): return
	#We have a logfile handle here.
	CPDIR = os.path.join(os.environ['HOME'], '.curphoo')
	CPDATE = time.strftime('curphoo-%F-%T.log',time.localtime())
	CPLOG = os.path.join(CPDIR,CPDATE)

	#This doesn't work FIXME
	g = copy.deepcopy(f)
	#This might be a small data loss on a heaviily loaded machine.
	try:
		f.log = open(CPLOG, 'a')
	except:
		pass
	g.close()
	return f
