#
#   Copyright by Mark Weyer
#
#   Partly based on code by (in alphabetical order) Berni, Immi, and Jela:
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

Labskaus = {
  name = "Potpourri"
  name[de] = "Labskaus"
  author = "Mark Weyer (editor)"
  author[de] = "Mark Weyer (Hrsg.)"
  description[de] = "Das ist alles nur geklaut"
  pics = ivElephant, bmG, jjJahr, Baelle, ihLila, mbBunt
  greypic = grau
  startpic = inGras.xpm
  startdist="BACDADBCDB"
  chaingrass = 1
  emptypic = jhBallons

  <<
    var zuklappen=1;    # Fr bmG
    var zeit, zeit2;    # Fr jjJahr
    var drehpos;        # Fr Baelle
    var ballon;         # Fr jhBallons

    global={
      zeit = (zeit + 1) % 512; # 32*4*4
      zeit2 = zeit / 32;
      drehpos = (drehpos + 1) % 12;
    };
  >>

  ivElephant = {
    numexplode = 6
    numexplode1 = 9
    pics=ivElefant.xpm

    <<
      ivElephant={
        switch {
          0?0?0?0? -> {{A,Y,a};*;};
          0?1?0?0? -> {{B,U,W};*;};
          1?1?1?0? -> {{J,R,T};*;};
          1?0?0?0? -> {{M,Q,S};*;};
          1?1?0?1? -> {{O,V,X};*;};
          -> schema16;
        };
      };
    >>
  }

  bmG = {
    numexplode = 2
    pics=bmKarten.xpm,bmStrich.xpm

    <<
      bmG={
        switch {
          falling -> G*;
          zuklappen => {
            # Grade aufgekommen oder so was.
            # Aber erst noch ein Bildchen lang normal, weil sonst die
            # Start-Karten schon beim ersten Bild leicht umklappen.
            {zuklappen=0;G*}, V*, 1A*, P*
          };
          1:70 => {
            # Kurz aufklappen
            P*, 1A*, V*,
            G*,G*,G*,G*,G*,G*,G*,G*,G*,G*,G*,G*,G*,G*,
            V*, 1A*, P*
          };
          -> A*; # zugeklappt
        };
      };
    >>
  }

  jjJahr = {
    numexplode = 4
    pics=jjWinter1.xpm,jjWinter2.xpm,jjWinter3.xpm,jjWinter4.xpm,
         jjFruehling1.xpm,jjFruehling2.xpm,jjFruehling3.xpm,jjFruehling4.xpm,
         jjSommer1.xpm,jjSommer2.xpm,jjSommer3.xpm,jjSommer4.xpm,
         jjHerbst1.xpm,jjHerbst2.xpm,jjHerbst3.xpm,jjHerbst4.xpm

    <<
      jjJahr={file=zeit2@;schema16;};
    >>
  }

  Baelle = {
    numexplode = 4
    pics=ibBaelle.xpm,ibBaelle2.xpm

    <<
      Baelle={schema16;pos=drehpos@;1*};
    >>    
  }

  ihLila = {
    numexplode=4
    numexplode1=6
    neighbours=1
    pics=ihLila.xpm

    <<
      ihLila=schemaDiag2;
    >>
  }

  mbBunt = {
    numexplode=2
    pics=mbBunt.xpm

    <<
      mbBunt={pos=37;*};
    >>
  }

  jhBallons = {
    pics=jhBallons.xpm

    <<
      jhBallons = {
	if ballon@(0,1)==1 || (????0??? && 1:1000)
	  => {{ballon@(0,0)=1;*}, ballon@(0,0)=0};
      };
    >>
  }

  grau = {
    pics=explosion.xpm          # Eigentlich braucht grau gar keine Bilder

    <<
      grau.init = {
        switch {
          1:6 -> kind=mbBunt;
          1:5 -> kind=ihLila;
          1:4 -> kind=Baelle;
          1:3 -> kind=jjJahr;
          1:2 -> kind=bmG;
              -> kind=ivElephant;
        };
      };
    >>
  }

}
