#
#   Copyright by Mark Weyer
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

Tennis={
  name="Tennis"
  author="Mark Weyer"
  numexplode=5
  numexplode1=6
  toptime=200
  pics=Yellow,Green,Grey,Blue
  greypic=Grau
  startpic=Start
  startdist="AAAAAAAAAA","AAAAAAAAAA","AAAAAAAAAA"
  emptypic=Hinter
  bgcolor=0,255,255
  chaingrass=0
  topcolor=255,128,0
  textcolor=0,0,0
  neighbours=1
  description="Don't be confused by extra balls."
  description[de]="Manche Blle sind nur zur Verwirrung."

  <<
    var time,shorttime,part,rack01,rack10,colour;

    global={
      time+=1; time%=18;
      shorttime=time; shorttime%=9;
      part=time; part/=9;
    };

    mtBL={pos=shorttime@; pos+=pos; pos+=18};
    mtBR={pos=shorttime@; pos+=pos; pos+=19};
    mtTL={pos=shorttime@; pos+=pos};
    mtTR={pos=shorttime@; pos+=pos; pos+=1};
    mtM={pos=shorttime@};

    Racket={
      switch {
        ???1???? -> rack01=0;
        ?1?????? -> rack01=0;
        ?0?0???? -> rack01=1;
      };
      switch {
        ???????1 -> rack10=2;
        ?????1?? -> rack10=2;
        ?????0?0 -> rack10=1;
      };
      switch {
        time@==  .. 3 -> pos=rack10;
        time@== 4     -> if rack10==rack01 -> pos=rack01 else B;
        time@== 5..12 -> pos=rack01;
        time@==13     -> if rack10==rack01 -> pos=rack01 else B;
        time@==13..   -> pos=rack10;
      };
    };

    OtherBlobs={
      file=kind@(0,1);
      if file==0..3 -> {
        if file==kind@(1,0) && part@==0 -> {mtTL; *};
        if file==kind@(-1,0) && part@==1 -> {file+=4; mtTR; *};
      };
      file=kind@(0,-1);
      if file==0..3 -> {
        if file==kind@(-1,0) && part@==0 -> {mtBR; *};
        if file==kind@(1,0) && part@==1 -> {file+=4; mtBL; *};
      };
    };

    Grau={8A*; OtherBlobs};

    RandomColour={switch {
        1:4 -> colour=9;
        1:3 -> colour=10;
        1:2 -> colour=11;
            -> colour=12;
      };
    };

    Start.init={RandomColour;};

    Start={8B*;
      if shorttime@==0 && 1:3 -> RandomColour;
      pos=shorttime@; file=colour; *;
      OtherBlobs};

    RoofA={8;{A,B,C,D,E};*};
    RoofB={9;{A,B,C,D,E,F,G};*};
    RoofC={10;{A,B,C,D,E};*};
    RoofD={11;{A,B,C,D,E,F,G};*};

    Hinter= {
      switch {
        ??0?0?0? -> {RoofA; OtherBlobs};
        ??110?0? -> {RoofA; OtherBlobs};
        ??11011? -> {RoofA; OtherBlobs};
        ??0?011? -> {RoofA; OtherBlobs};
        ??100?0? -> {RoofB; OtherBlobs};
        ??10011? -> {RoofB; OtherBlobs};
        ??10001? -> RoofC;
        ??0?001? -> {RoofD; OtherBlobs};
        ??11001? -> {RoofD; OtherBlobs};
      };
    };

    Blob={
      8;Racket;*;
      if part@==0
        -> {
          switch {
            ?0?1?1?? || ?0???1?0 -> {13;mtM;*};
            ?1???0?1 || ?1?0?0?? -> {14;mtM;*};
                                 -> {9A*};
          };
          if ?1?????? -> {10;mtBL;*};
          if ?????1?? -> {10;mtTR;*};
          if ?0???0?? -> {12;mtM;*};
        }
        else {
          switch {
            ???1?1?0 || ?0?1???0 -> {13;mtM;*};
            ?1?0???1 || ???0?0?1 -> {14;mtM;*};
                                 -> {9A*};
          };
          if ???1???? -> {11;mtTL;*};
          if ???????1 -> {11;mtBR;*};
          if ???0???0 -> {12;mtM;*};
        };
      OtherBlobs;
    };

    Yellow=Blob;
    Green=Blob;
    Grey=Blob;
    Blue=Blob;
  >>

  Yellow={pics=
    mtYellowLeft.xpm,  mtGreenLeft.xpm,  mtGreyLeft.xpm,  mtBlueLeft.xpm,
    mtYellowRight.xpm, mtGreenRight.xpm, mtGreyRight.xpm, mtBlueRight.xpm,
    mtRacket.xpm, mtSource.xpm,
    mtYellowLeft.xpm, mtYellowRight.xpm,
    mtYellowBounce.xpm, mtYellowIn.xpm, mtYellowOut.xpm
  }

  Green={pics=
    mtYellowLeft.xpm,  mtGreenLeft.xpm,  mtGreyLeft.xpm,  mtBlueLeft.xpm,
    mtYellowRight.xpm, mtGreenRight.xpm, mtGreyRight.xpm, mtBlueRight.xpm,
    mtRacket.xpm, mtSource.xpm,
    mtGreenLeft.xpm, mtGreenRight.xpm,
    mtGreenBounce.xpm, mtGreenIn.xpm, mtGreenOut.xpm
  }

  Grey={pics=
    mtYellowLeft.xpm,  mtGreenLeft.xpm,  mtGreyLeft.xpm,  mtBlueLeft.xpm,
    mtYellowRight.xpm, mtGreenRight.xpm, mtGreyRight.xpm, mtBlueRight.xpm,
    mtRacket.xpm, mtSource.xpm,
    mtGreyLeft.xpm, mtGreyRight.xpm,
    mtGreyBounce.xpm, mtGreyIn.xpm, mtGreyOut.xpm
  }

  Blue={pics=
    mtYellowLeft.xpm,  mtGreenLeft.xpm,  mtGreyLeft.xpm,  mtBlueLeft.xpm,
    mtYellowRight.xpm, mtGreenRight.xpm, mtGreyRight.xpm, mtBlueRight.xpm,
    mtRacket.xpm, mtSource.xpm,
    mtBlueLeft.xpm, mtBlueRight.xpm,
    mtBlueBounce.xpm, mtBlueIn.xpm, mtBlueOut.xpm
  }

  Grau={pics=
    mtYellowLeft.xpm,  mtGreenLeft.xpm,  mtGreyLeft.xpm,  mtBlueLeft.xpm,
    mtYellowRight.xpm, mtGreenRight.xpm, mtGreyRight.xpm, mtBlueRight.xpm,
    mtWall.xpm}

  Start={pics=
    mtYellowLeft.xpm,  mtGreenLeft.xpm,  mtGreyLeft.xpm,  mtBlueLeft.xpm,
    mtYellowRight.xpm, mtGreenRight.xpm, mtGreyRight.xpm, mtBlueRight.xpm,
    mtRacket.xpm,
    mtYellowBounce.xpm, mtGreyBounce.xpm,
    mtBlueBounce.xpm, mtGreenBounce.xpm
  }

  Hinter={pics=
    mtYellowLeft.xpm,  mtGreenLeft.xpm,  mtGreyLeft.xpm,  mtBlueLeft.xpm,
    mtYellowRight.xpm, mtGreenRight.xpm, mtGreyRight.xpm, mtBlueRight.xpm,
    mtRoof1.xpm, mtRoof2.xpm, mtRoof3.xpm, mtRoof4.xpm
  }
}



