/*
 * Copyright (C) 1999-2011. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version $RCSfile: numeric_character_reference_xml_model.c,v $ $Revision: 1.4 $ $Date: 2009-01-31 16:06:30 $ $Author: christian $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef NUMERIC_CHARACTER_REFERENCE_XML_MODEL_SOURCE
#define NUMERIC_CHARACTER_REFERENCE_XML_MODEL_SOURCE

#include <stddef.h>
#include "../../../constant/model/memory/integer_memory_model.c"

//
// The references &#00; to &#08; are unused.
//

/** The horizontal tab numeric character reference xml model. */
static wchar_t HORIZONTAL_TAB_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'0', L'9', L';'};
static wchar_t* HORIZONTAL_TAB_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = HORIZONTAL_TAB_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* HORIZONTAL_TAB_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The line feed numeric character reference xml model. */
static wchar_t LINE_FEED_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'0', L';'};
static wchar_t* LINE_FEED_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = LINE_FEED_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* LINE_FEED_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

//
// The references &#11; to &#12; are unused.
//

/** The carriage return numeric character reference xml model. */
static wchar_t CARRIAGE_RETURN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'3', L';'};
static wchar_t* CARRIAGE_RETURN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CARRIAGE_RETURN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CARRIAGE_RETURN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

//
// The references &#14; to &#31; are unused.
//

/** The space   numeric character reference xml model. */
static wchar_t SPACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'3', L'2', L';'};
static wchar_t* SPACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SPACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SPACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The exclamation mark ! numeric character reference xml model. */
static wchar_t EXCLAMATION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'3', L'3', L';'};
static wchar_t* EXCLAMATION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = EXCLAMATION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* EXCLAMATION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The quotation mark " numeric character reference xml model. */
static wchar_t QUOTATION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'3', L'4', L';'};
static wchar_t* QUOTATION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = QUOTATION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* QUOTATION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The number sign # numeric character reference xml model. */
static wchar_t NUMBER_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'3', L'5', L';'};
static wchar_t* NUMBER_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = NUMBER_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* NUMBER_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The dollar sign $ numeric character reference xml model. */
static wchar_t DOLLAR_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'3', L'6', L';'};
static wchar_t* DOLLAR_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DOLLAR_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DOLLAR_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The percent sign % numeric character reference xml model. */
static wchar_t PERCENT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'3', L'7', L';'};
static wchar_t* PERCENT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = PERCENT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* PERCENT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The ampersand & numeric character reference xml model. */
static wchar_t AMPERSAND_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'3', L'8', L';'};
static wchar_t* AMPERSAND_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = AMPERSAND_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* AMPERSAND_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The apostrophe ' numeric character reference xml model. */
static wchar_t APOSTROPHE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'3', L'9', L';'};
static wchar_t* APOSTROPHE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = APOSTROPHE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* APOSTROPHE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The left parenthesis ( numeric character reference xml model. */
static wchar_t LEFT_PARENTHESIS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'4', L'0', L';'};
static wchar_t* LEFT_PARENTHESIS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = LEFT_PARENTHESIS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* LEFT_PARENTHESIS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The right parenthesis ) numeric character reference xml model. */
static wchar_t RIGHT_PARENTHESIS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'4', L'1', L';'};
static wchar_t* RIGHT_PARENTHESIS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = RIGHT_PARENTHESIS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* RIGHT_PARENTHESIS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The asterisk * numeric character reference xml model. */
static wchar_t ASTERISK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'4', L'2', L';'};
static wchar_t* ASTERISK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = ASTERISK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* ASTERISK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The plus sign + numeric character reference xml model. */
static wchar_t PLUS_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'4', L'3', L';'};
static wchar_t* PLUS_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = PLUS_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* PLUS_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The comma , numeric character reference xml model. */
static wchar_t COMMA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'4', L'4', L';'};
static wchar_t* COMMA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = COMMA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* COMMA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The hyphen - numeric character reference xml model. */
static wchar_t HYPHEN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'4', L'5', L';'};
static wchar_t* HYPHEN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = HYPHEN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* HYPHEN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The period (fullstop, dot) . numeric character reference xml model. */
static wchar_t PERIOD_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'4', L'6', L';'};
static wchar_t* PERIOD_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = PERIOD_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* PERIOD_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The solidus (slash) / numeric character reference xml model. */
static wchar_t SOLIDUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'4', L'7', L';'};
static wchar_t* SOLIDUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SOLIDUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SOLIDUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The digit 0 numeric character reference xml model. */
static wchar_t DIGIT_0_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'4', L'8', L';'};
static wchar_t* DIGIT_0_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DIGIT_0_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DIGIT_0_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The digit 1 numeric character reference xml model. */
static wchar_t DIGIT_1_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'4', L'9', L';'};
static wchar_t* DIGIT_1_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DIGIT_1_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DIGIT_1_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The digit 2 numeric character reference xml model. */
static wchar_t DIGIT_2_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'5', L'0', L';'};
static wchar_t* DIGIT_2_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DIGIT_2_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DIGIT_2_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The digit 3 numeric character reference xml model. */
static wchar_t DIGIT_3_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'5', L'1', L';'};
static wchar_t* DIGIT_3_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DIGIT_3_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DIGIT_3_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The digit 4 numeric character reference xml model. */
static wchar_t DIGIT_4_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'5', L'2', L';'};
static wchar_t* DIGIT_4_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DIGIT_4_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DIGIT_4_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The digit 5 numeric character reference xml model. */
static wchar_t DIGIT_5_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'5', L'3', L';'};
static wchar_t* DIGIT_5_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DIGIT_5_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DIGIT_5_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The digit 6 numeric character reference xml model. */
static wchar_t DIGIT_6_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'5', L'4', L';'};
static wchar_t* DIGIT_6_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DIGIT_6_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DIGIT_6_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The digit 7 numeric character reference xml model. */
static wchar_t DIGIT_7_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'5', L'5', L';'};
static wchar_t* DIGIT_7_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DIGIT_7_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DIGIT_7_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The digit 8 numeric character reference xml model. */
static wchar_t DIGIT_8_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'5', L'6', L';'};
static wchar_t* DIGIT_8_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DIGIT_8_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DIGIT_8_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The digit 9 numeric character reference xml model. */
static wchar_t DIGIT_9_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'5', L'7', L';'};
static wchar_t* DIGIT_9_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DIGIT_9_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DIGIT_9_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The colon : numeric character reference xml model. */
static wchar_t COLON_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'5', L'8', L';'};
static wchar_t* COLON_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = COLON_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* COLON_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The semi-colon ; numeric character reference xml model. */
static wchar_t SEMICOLON_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'5', L'9', L';'};
static wchar_t* SEMICOLON_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SEMICOLON_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SEMICOLON_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The less than < numeric character reference xml model. */
static wchar_t LESS_THAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'6', L'0', L';'};
static wchar_t* LESS_THAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = LESS_THAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* LESS_THAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The equals sign = numeric character reference xml model. */
static wchar_t EQUALS_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'6', L'1', L';'};
static wchar_t* EQUALS_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = EQUALS_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* EQUALS_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The greater than > numeric character reference xml model. */
static wchar_t GREATER_THAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'6', L'2', L';'};
static wchar_t* GREATER_THAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = GREATER_THAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* GREATER_THAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The question mark ? numeric character reference xml model. */
static wchar_t QUESTION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'6', L'3', L';'};
static wchar_t* QUESTION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = QUESTION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* QUESTION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The commercial at @ numeric character reference xml model. */
static wchar_t COMMERCIAL_AT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'6', L'4', L';'};
static wchar_t* COMMERCIAL_AT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = COMMERCIAL_AT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* COMMERCIAL_AT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter a numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_A_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'6', L'5', L';'};
static wchar_t* CAPITAL_LETTER_A_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_A_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_A_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter b numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_B_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'6', L'6', L';'};
static wchar_t* CAPITAL_LETTER_B_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_B_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_B_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter c numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_C_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'6', L'7', L';'};
static wchar_t* CAPITAL_LETTER_C_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_C_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_C_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter d numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_D_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'6', L'8', L';'};
static wchar_t* CAPITAL_LETTER_D_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_D_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_D_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter e numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_E_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'6', L'9', L';'};
static wchar_t* CAPITAL_LETTER_E_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_E_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_E_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter f numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_F_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'7', L'0', L';'};
static wchar_t* CAPITAL_LETTER_F_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_F_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_F_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter g numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_G_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'7', L'1', L';'};
static wchar_t* CAPITAL_LETTER_G_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_G_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_G_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter h numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_H_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'7', L'2', L';'};
static wchar_t* CAPITAL_LETTER_H_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_H_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_H_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter i numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_I_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'7', L'3', L';'};
static wchar_t* CAPITAL_LETTER_I_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_I_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_I_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter j numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_J_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'7', L'4', L';'};
static wchar_t* CAPITAL_LETTER_J_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_J_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_J_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter k numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_K_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'7', L'5', L';'};
static wchar_t* CAPITAL_LETTER_K_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_K_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_K_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter l numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_L_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'7', L'6', L';'};
static wchar_t* CAPITAL_LETTER_L_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_L_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_L_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter m numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_M_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'7', L'7', L';'};
static wchar_t* CAPITAL_LETTER_M_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_M_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_M_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter n numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_N_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'7', L'8', L';'};
static wchar_t* CAPITAL_LETTER_N_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_N_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_N_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter o numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_O_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'7', L'9', L';'};
static wchar_t* CAPITAL_LETTER_O_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_O_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_O_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter p numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_P_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'8', L'0', L';'};
static wchar_t* CAPITAL_LETTER_P_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_P_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_P_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter q numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_Q_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'8', L'1', L';'};
static wchar_t* CAPITAL_LETTER_Q_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_Q_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_Q_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter r numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_R_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'8', L'2', L';'};
static wchar_t* CAPITAL_LETTER_R_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_R_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_R_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter s numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_S_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'8', L'3', L';'};
static wchar_t* CAPITAL_LETTER_S_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_S_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_S_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter t numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_T_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'8', L'4', L';'};
static wchar_t* CAPITAL_LETTER_T_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_T_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_T_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter u numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_U_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'8', L'5', L';'};
static wchar_t* CAPITAL_LETTER_U_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_U_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_U_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter v numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_V_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'8', L'6', L';'};
static wchar_t* CAPITAL_LETTER_V_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_V_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_V_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter w numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_W_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'8', L'7', L';'};
static wchar_t* CAPITAL_LETTER_W_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_W_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_W_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter x numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_X_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'8', L'8', L';'};
static wchar_t* CAPITAL_LETTER_X_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_X_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_X_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter y numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_Y_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'8', L'9', L';'};
static wchar_t* CAPITAL_LETTER_Y_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_Y_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_Y_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital letter z numeric character reference xml model. */
static wchar_t CAPITAL_LETTER_Z_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'9', L'0', L';'};
static wchar_t* CAPITAL_LETTER_Z_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_LETTER_Z_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_LETTER_Z_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The left square bracket [ numeric character reference xml model. */
static wchar_t LEFT_SQUARE_BRACKET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'9', L'1', L';'};
static wchar_t* LEFT_SQUARE_BRACKET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = LEFT_SQUARE_BRACKET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* LEFT_SQUARE_BRACKET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The reverse solidus (backslash) \ numeric character reference xml model. */
static wchar_t REVERSE_SOLIDUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'9', L'2', L';'};
static wchar_t* REVERSE_SOLIDUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = REVERSE_SOLIDUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* REVERSE_SOLIDUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The right square bracket ] numeric character reference xml model. */
static wchar_t RIGHT_SQUARE_BRACKET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'9', L'3', L';'};
static wchar_t* RIGHT_SQUARE_BRACKET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = RIGHT_SQUARE_BRACKET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* RIGHT_SQUARE_BRACKET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The caret ^ numeric character reference xml model. */
static wchar_t CARET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'9', L'4', L';'};
static wchar_t* CARET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CARET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CARET_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The horizontal bar (underscore) _ numeric character reference xml model. */
static wchar_t HORIZONTAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'9', L'5', L';'};
static wchar_t* HORIZONTAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = HORIZONTAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* HORIZONTAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The grave accent ` numeric character reference xml model. */
static wchar_t GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'9', L'6', L';'};
static wchar_t* GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter a numeric character reference xml model. */
static wchar_t SMALL_LETTER_A_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'9', L'7', L';'};
static wchar_t* SMALL_LETTER_A_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_A_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_A_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter b numeric character reference xml model. */
static wchar_t SMALL_LETTER_B_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'9', L'8', L';'};
static wchar_t* SMALL_LETTER_B_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_B_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_B_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter c numeric character reference xml model. */
static wchar_t SMALL_LETTER_C_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'9', L'9', L';'};
static wchar_t* SMALL_LETTER_C_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_C_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_C_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_5_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter d numeric character reference xml model. */
static wchar_t SMALL_LETTER_D_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'0', L'0', L';'};
static wchar_t* SMALL_LETTER_D_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_D_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_D_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter e numeric character reference xml model. */
static wchar_t SMALL_LETTER_E_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'0', L'1', L';'};
static wchar_t* SMALL_LETTER_E_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_E_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_E_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter f numeric character reference xml model. */
static wchar_t SMALL_LETTER_F_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'0', L'2', L';'};
static wchar_t* SMALL_LETTER_F_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_F_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_F_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter g numeric character reference xml model. */
static wchar_t SMALL_LETTER_G_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'0', L'3', L';'};
static wchar_t* SMALL_LETTER_G_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_G_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_G_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter h numeric character reference xml model. */
static wchar_t SMALL_LETTER_H_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'0', L'4', L';'};
static wchar_t* SMALL_LETTER_H_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_H_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_H_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter i numeric character reference xml model. */
static wchar_t SMALL_LETTER_I_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'0', L'5', L';'};
static wchar_t* SMALL_LETTER_I_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_I_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_I_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter j numeric character reference xml model. */
static wchar_t SMALL_LETTER_J_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'0', L'6', L';'};
static wchar_t* SMALL_LETTER_J_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_J_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_J_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter k numeric character reference xml model. */
static wchar_t SMALL_LETTER_K_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'0', L'7', L';'};
static wchar_t* SMALL_LETTER_K_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_K_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_K_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter l numeric character reference xml model. */
static wchar_t SMALL_LETTER_L_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'0', L'8', L';'};
static wchar_t* SMALL_LETTER_L_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_L_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_L_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter m numeric character reference xml model. */
static wchar_t SMALL_LETTER_M_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'0', L'9', L';'};
static wchar_t* SMALL_LETTER_M_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_M_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_M_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter n numeric character reference xml model. */
static wchar_t SMALL_LETTER_N_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'1', L'0', L';'};
static wchar_t* SMALL_LETTER_N_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_N_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_N_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter o numeric character reference xml model. */
static wchar_t SMALL_LETTER_O_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'1', L'1', L';'};
static wchar_t* SMALL_LETTER_O_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_O_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_O_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter p numeric character reference xml model. */
static wchar_t SMALL_LETTER_P_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'1', L'2', L';'};
static wchar_t* SMALL_LETTER_P_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_P_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_P_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter q numeric character reference xml model. */
static wchar_t SMALL_LETTER_Q_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'1', L'3', L';'};
static wchar_t* SMALL_LETTER_Q_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_Q_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_Q_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter r numeric character reference xml model. */
static wchar_t SMALL_LETTER_R_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'1', L'4', L';'};
static wchar_t* SMALL_LETTER_R_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_R_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_R_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter s numeric character reference xml model. */
static wchar_t SMALL_LETTER_S_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'1', L'5', L';'};
static wchar_t* SMALL_LETTER_S_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_S_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_S_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter t numeric character reference xml model. */
static wchar_t SMALL_LETTER_T_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'1', L'6', L';'};
static wchar_t* SMALL_LETTER_T_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_T_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_T_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter u numeric character reference xml model. */
static wchar_t SMALL_LETTER_U_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'1', L'7', L';'};
static wchar_t* SMALL_LETTER_U_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_U_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_U_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter v numeric character reference xml model. */
static wchar_t SMALL_LETTER_V_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'1', L'8', L';'};
static wchar_t* SMALL_LETTER_V_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_V_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_V_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter w numeric character reference xml model. */
static wchar_t SMALL_LETTER_W_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'1', L'9', L';'};
static wchar_t* SMALL_LETTER_W_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_W_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_W_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter x numeric character reference xml model. */
static wchar_t SMALL_LETTER_X_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'2', L'0', L';'};
static wchar_t* SMALL_LETTER_X_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_X_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_X_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter y numeric character reference xml model. */
static wchar_t SMALL_LETTER_Y_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'2', L'1', L';'};
static wchar_t* SMALL_LETTER_Y_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_Y_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_Y_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small letter z numeric character reference xml model. */
static wchar_t SMALL_LETTER_Z_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'2', L'2', L';'};
static wchar_t* SMALL_LETTER_Z_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_LETTER_Z_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_LETTER_Z_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The left curly brace { numeric character reference xml model. */
static wchar_t LEFT_CURLY_BRACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'2', L'3', L';'};
static wchar_t* LEFT_CURLY_BRACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = LEFT_CURLY_BRACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* LEFT_CURLY_BRACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The vertical bar | numeric character reference xml model. */
static wchar_t VERTICAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'2', L'4', L';'};
static wchar_t* VERTICAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = VERTICAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* VERTICAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The right curly brace } numeric character reference xml model. */
static wchar_t RIGHT_CURLY_BRACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'2', L'5', L';'};
static wchar_t* RIGHT_CURLY_BRACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = RIGHT_CURLY_BRACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* RIGHT_CURLY_BRACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The tilde ~ numeric character reference xml model. */
static wchar_t TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'2', L'6', L';'};
static wchar_t* TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

//
// The references &#127; to &#159; are unused.
//

/** The non-breaking space   numeric character reference xml model. */
static wchar_t NON_BREAKING_SPACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'6', L'0', L';'};
static wchar_t* NON_BREAKING_SPACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = NON_BREAKING_SPACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* NON_BREAKING_SPACE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The inverted exclamation numeric character reference xml model. */
static wchar_t INVERTED_EXCLAMATION_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'6', L'1', L';'};
static wchar_t* INVERTED_EXCLAMATION_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = INVERTED_EXCLAMATION_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* INVERTED_EXCLAMATION_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The cent sign numeric character reference xml model. */
static wchar_t CENT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'6', L'2', L';'};
static wchar_t* CENT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CENT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CENT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The pound sterling numeric character reference xml model. */
static wchar_t POUND_STERLING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'6', L'3', L';'};
static wchar_t* POUND_STERLING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = POUND_STERLING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* POUND_STERLING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The general currency sign numeric character reference xml model. */
static wchar_t GENERAL_CURRENCY_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'6', L'4', L';'};
static wchar_t* GENERAL_CURRENCY_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = GENERAL_CURRENCY_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* GENERAL_CURRENCY_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The yen sign numeric character reference xml model. */
static wchar_t YEN_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'6', L'5', L';'};
static wchar_t* YEN_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = YEN_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* YEN_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The broken vertical bar numeric character reference xml model. */
static wchar_t BROKEN_VERTICAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'6', L'6', L';'};
static wchar_t* BROKEN_VERTICAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = BROKEN_VERTICAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* BROKEN_VERTICAL_BAR_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The section sign numeric character reference xml model. */
static wchar_t SECTION_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'6', L'7', L';'};
static wchar_t* SECTION_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SECTION_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SECTION_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The umlaut (dieresis) numeric character reference xml model. */
static wchar_t UMLAUT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'6', L'8', L';'};
static wchar_t* UMLAUT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = UMLAUT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* UMLAUT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The copyright numeric character reference xml model. */
static wchar_t COPYRIGHT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'6', L'9', L';'};
static wchar_t* COPYRIGHT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = COPYRIGHT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* COPYRIGHT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The feminine ordinal numeric character reference xml model. */
static wchar_t FEMININE_ORDINAL_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'7', L'0', L';'};
static wchar_t* FEMININE_ORDINAL_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = FEMININE_ORDINAL_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* FEMININE_ORDINAL_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The left angle quote, guillemotleft numeric character reference xml model. */
static wchar_t LEFT_ANGLE_QUOTE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'7', L'1', L';'};
static wchar_t* LEFT_ANGLE_QUOTE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = LEFT_ANGLE_QUOTE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* LEFT_ANGLE_QUOTE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The not sign numeric character reference xml model. */
static wchar_t NOT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'7', L'2', L';'};
static wchar_t* NOT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = NOT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* NOT_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The soft hyphen numeric character reference xml model. */
static wchar_t SOFT_HYPHEN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'7', L'3', L';'};
static wchar_t* SOFT_HYPHEN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SOFT_HYPHEN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SOFT_HYPHEN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The registered trademark numeric character reference xml model. */
static wchar_t REGISTERED_TRADEMARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'7', L'4', L';'};
static wchar_t* REGISTERED_TRADEMARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = REGISTERED_TRADEMARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* REGISTERED_TRADEMARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The macron accent numeric character reference xml model. */
static wchar_t MACRON_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'7', L'5', L';'};
static wchar_t* MACRON_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = MACRON_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* MACRON_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The degree sign numeric character reference xml model. */
static wchar_t DEGREE_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'7', L'6', L';'};
static wchar_t* DEGREE_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DEGREE_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DEGREE_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The plus or minus numeric character reference xml model. */
static wchar_t PLUS_OR_MINUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'7', L'7', L';'};
static wchar_t* PLUS_OR_MINUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = PLUS_OR_MINUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* PLUS_OR_MINUS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The superscript two � numeric character reference xml model. */
static wchar_t SUPERSCRIPT_TWO_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'7', L'8', L';'};
static wchar_t* SUPERSCRIPT_TWO_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SUPERSCRIPT_TWO_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SUPERSCRIPT_TWO_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The superscript three � numeric character reference xml model. */
static wchar_t SUPERSCRIPT_THREE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'7', L'9', L';'};
static wchar_t* SUPERSCRIPT_THREE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SUPERSCRIPT_THREE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SUPERSCRIPT_THREE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The acute accent numeric character reference xml model. */
static wchar_t ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'8', L'0', L';'};
static wchar_t* ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The micro sign numeric character reference xml model. */
static wchar_t MICRO_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'8', L'1', L';'};
static wchar_t* MICRO_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = MICRO_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* MICRO_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The paragraph sign � numeric character reference xml model. */
static wchar_t PARAGRAPH_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'8', L'2', L';'};
static wchar_t* PARAGRAPH_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = PARAGRAPH_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* PARAGRAPH_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The middle dot numeric character reference xml model. */
static wchar_t MIDDLE_DOT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'8', L'3', L';'};
static wchar_t* MIDDLE_DOT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = MIDDLE_DOT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* MIDDLE_DOT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The cedilla numeric character reference xml model. */
static wchar_t CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'8', L'4', L';'};
static wchar_t* CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The superscript one � numeric character reference xml model. */
static wchar_t SUPERSCRIPT_ONE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'8', L'5', L';'};
static wchar_t* SUPERSCRIPT_ONE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SUPERSCRIPT_ONE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SUPERSCRIPT_ONE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The masculine ordinal numeric character reference xml model. */
static wchar_t MASCULINE_ORDINAL_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'8', L'6', L';'};
static wchar_t* MASCULINE_ORDINAL_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = MASCULINE_ORDINAL_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* MASCULINE_ORDINAL_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The right angle quote guillemotright numeric character reference xml model. */
static wchar_t RIGHT_ANGLE_QUOTE_GUILLEMOTRIGHT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'8', L'7', L';'};
static wchar_t* RIGHT_ANGLE_QUOTE_GUILLEMOTRIGHT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = RIGHT_ANGLE_QUOTE_GUILLEMOTRIGHT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* RIGHT_ANGLE_QUOTE_GUILLEMOTRIGHT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The fraction one-fourth numeric character reference xml model. */
static wchar_t FRACTION_ONE_FOURTH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'8', L'8', L';'};
static wchar_t* FRACTION_ONE_FOURTH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = FRACTION_ONE_FOURTH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* FRACTION_ONE_FOURTH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The fraction one-half � numeric character reference xml model. */
static wchar_t FRACTION_ONE_HALF_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'8', L'9', L';'};
static wchar_t* FRACTION_ONE_HALF_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = FRACTION_ONE_HALF_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* FRACTION_ONE_HALF_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The fraction three-fourths � numeric character reference xml model. */
static wchar_t FRACTION_THREE_FOURTHS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'9', L'0', L';'};
static wchar_t* FRACTION_THREE_FOURTHS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = FRACTION_THREE_FOURTHS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* FRACTION_THREE_FOURTHS_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The inverted question mark numeric character reference xml model. */
static wchar_t INVERTED_QUESTION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'9', L'1', L';'};
static wchar_t* INVERTED_QUESTION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = INVERTED_QUESTION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* INVERTED_QUESTION_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital a grave accent numeric character reference xml model. */
static wchar_t CAPITAL_A_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'9', L'2', L';'};
static wchar_t* CAPITAL_A_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_A_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_A_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital a acute accent numeric character reference xml model. */
static wchar_t CAPITAL_A_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'9', L'3', L';'};
static wchar_t* CAPITAL_A_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_A_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_A_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital a circumflex accent numeric character reference xml model. */
static wchar_t CAPITAL_A_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'9', L'4', L';'};
static wchar_t* CAPITAL_A_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_A_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_A_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital a tilde numeric character reference xml model. */
static wchar_t CAPITAL_A_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'9', L'5', L';'};
static wchar_t* CAPITAL_A_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_A_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_A_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital a umlaut mark (dieresis) numeric character reference xml model. */
static wchar_t CAPITAL_A_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'9', L'6', L';'};
static wchar_t* CAPITAL_A_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_A_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_A_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital a ring numeric character reference xml model. */
static wchar_t CAPITAL_A_RING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'9', L'7', L';'};
static wchar_t* CAPITAL_A_RING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_A_RING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_A_RING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital ae dipthong (ligature) numeric character reference xml model. */
static wchar_t CAPITAL_AE_DIPTHONG_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'9', L'8', L';'};
static wchar_t* CAPITAL_AE_DIPTHONG_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_AE_DIPTHONG_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_AE_DIPTHONG_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital c cedilla numeric character reference xml model. */
static wchar_t CAPITAL_C_CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'1', L'9', L'9', L';'};
static wchar_t* CAPITAL_C_CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_C_CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_C_CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital e grave accent numeric character reference xml model. */
static wchar_t CAPITAL_E_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'0', L'0', L';'};
static wchar_t* CAPITAL_E_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_E_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_E_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital e acute accent numeric character reference xml model. */
static wchar_t CAPITAL_E_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'0', L'1', L';'};
static wchar_t* CAPITAL_E_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_E_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_E_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital e circumflex accent numeric character reference xml model. */
static wchar_t CAPITAL_E_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'0', L'2', L';'};
static wchar_t* CAPITAL_E_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_E_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_E_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital e umlaut mark (dieresis) numeric character reference xml model. */
static wchar_t CAPITAL_E_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'0', L'3', L';'};
static wchar_t* CAPITAL_E_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_E_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_E_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital i grave accent numeric character reference xml model. */
static wchar_t CAPITAL_I_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'0', L'4', L';'};
static wchar_t* CAPITAL_I_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_I_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_I_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital i acute accent numeric character reference xml model. */
static wchar_t CAPITAL_I_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'0', L'5', L';'};
static wchar_t* CAPITAL_I_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_I_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_I_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital i circumflex accent numeric character reference xml model. */
static wchar_t CAPITAL_I_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'0', L'6', L';'};
static wchar_t* CAPITAL_I_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_I_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_I_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital i umlaut mark (dieresis) numeric character reference xml model. */
static wchar_t CAPITAL_I_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'0', L'7', L';'};
static wchar_t* CAPITAL_I_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_I_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_I_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital eth icelandic numeric character reference xml model. */
static wchar_t CAPITAL_ETH_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'0', L'8', L';'};
static wchar_t* CAPITAL_ETH_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_ETH_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_ETH_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital n tilde numeric character reference xml model. */
static wchar_t CAPITAL_N_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'0', L'9', L';'};
static wchar_t* CAPITAL_N_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_N_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_N_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital o grave accent numeric character reference xml model. */
static wchar_t CAPITAL_O_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'1', L'0', L';'};
static wchar_t* CAPITAL_O_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_O_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_O_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital o acute accent numeric character reference xml model. */
static wchar_t CAPITAL_O_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'1', L'1', L';'};
static wchar_t* CAPITAL_O_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_O_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_O_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital o circumflex accent numeric character reference xml model. */
static wchar_t CAPITAL_O_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'1', L'2', L';'};
static wchar_t* CAPITAL_O_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_O_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_O_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital o tilde numeric character reference xml model. */
static wchar_t CAPITAL_O_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'1', L'3', L';'};
static wchar_t* CAPITAL_O_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_O_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_O_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital o umlaut mark (dieresis) numeric character reference xml model. */
static wchar_t CAPITAL_O_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'1', L'4', L';'};
static wchar_t* CAPITAL_O_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_O_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_O_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The multiply sign numeric character reference xml model. */
static wchar_t MULTIPLY_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'1', L'5', L';'};
static wchar_t* MULTIPLY_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = MULTIPLY_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* MULTIPLY_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital o slash numeric character reference xml model. */
static wchar_t CAPITAL_O_SLASH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'1', L'6', L';'};
static wchar_t* CAPITAL_O_SLASH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_O_SLASH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_O_SLASH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital u grave accent numeric character reference xml model. */
static wchar_t CAPITAL_U_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'1', L'7', L';'};
static wchar_t* CAPITAL_U_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_U_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_U_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital u acute accent numeric character reference xml model. */
static wchar_t CAPITAL_U_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'1', L'8', L';'};
static wchar_t* CAPITAL_U_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_U_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_U_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital u circumflex accent numeric character reference xml model. */
static wchar_t CAPITAL_U_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'1', L'9', L';'};
static wchar_t* CAPITAL_U_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_U_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_U_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital u umlaut mark (dieresis) numeric character reference xml model. */
static wchar_t CAPITAL_U_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'2', L'0', L';'};
static wchar_t* CAPITAL_U_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_U_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_U_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital y acute accent numeric character reference xml model. */
static wchar_t CAPITAL_Y_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'2', L'1', L';'};
static wchar_t* CAPITAL_Y_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_Y_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_Y_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The capital thorn icelandic numeric character reference xml model. */
static wchar_t CAPITAL_THORN_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'2', L'2', L';'};
static wchar_t* CAPITAL_THORN_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = CAPITAL_THORN_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* CAPITAL_THORN_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small sharp s german (sz ligature) numeric character reference xml model. */
static wchar_t SMALL_SHARP_S_GERMAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'2', L'3', L';'};
static wchar_t* SMALL_SHARP_S_GERMAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_SHARP_S_GERMAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_SHARP_S_GERMAN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small a grave accent numeric character reference xml model. */
static wchar_t SMALL_A_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'2', L'4', L';'};
static wchar_t* SMALL_A_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_A_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_A_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small a acute accent numeric character reference xml model. */
static wchar_t SMALL_A_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'2', L'5', L';'};
static wchar_t* SMALL_A_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_A_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_A_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small a circumflex accent numeric character reference xml model. */
static wchar_t SMALL_A_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'2', L'6', L';'};
static wchar_t* SMALL_A_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_A_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_A_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small a tilde numeric character reference xml model. */
static wchar_t SMALL_A_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'2', L'7', L';'};
static wchar_t* SMALL_A_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_A_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_A_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small a umlaut mark (dieresis) numeric character reference xml model. */
static wchar_t SMALL_A_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'2', L'8', L';'};
static wchar_t* SMALL_A_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_A_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_A_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small a ring numeric character reference xml model. */
static wchar_t SMALL_A_RING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'2', L'9', L';'};
static wchar_t* SMALL_A_RING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_A_RING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_A_RING_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small ae dipthong (ligature) numeric character reference xml model. */
static wchar_t SMALL_AE_DIPTHONG_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'3', L'0', L';'};
static wchar_t* SMALL_AE_DIPTHONG_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_AE_DIPTHONG_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_AE_DIPTHONG_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small c cedilla numeric character reference xml model. */
static wchar_t SMALL_C_CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'3', L'1', L';'};
static wchar_t* SMALL_C_CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_C_CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_C_CEDILLA_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small e grave accent numeric character reference xml model. */
static wchar_t SMALL_E_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'3', L'2', L';'};
static wchar_t* SMALL_E_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_E_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_E_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small e acute accent numeric character reference xml model. */
static wchar_t SMALL_E_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'3', L'3', L';'};
static wchar_t* SMALL_E_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_E_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_E_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small e circumflex accent numeric character reference xml model. */
static wchar_t SMALL_E_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'3', L'4', L';'};
static wchar_t* SMALL_E_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_E_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_E_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small e umlaut mark (dieresis) numeric character reference xml model. */
static wchar_t SMALL_E_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'3', L'5', L';'};
static wchar_t* SMALL_E_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_E_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_E_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small i grave accent numeric character reference xml model. */
static wchar_t SMALL_I_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'3', L'6', L';'};
static wchar_t* SMALL_I_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_I_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_I_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small i acute accent numeric character reference xml model. */
static wchar_t SMALL_I_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'3', L'7', L';'};
static wchar_t* SMALL_I_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_I_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_I_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small i circumflex accent numeric character reference xml model. */
static wchar_t SMALL_I_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'3', L'8', L';'};
static wchar_t* SMALL_I_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_I_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_I_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small i umlaut mark (dieresis) numeric character reference xml model. */
static wchar_t SMALL_I_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'3', L'9', L';'};
static wchar_t* SMALL_I_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_I_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_I_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small eth icelandic numeric character reference xml model. */
static wchar_t SMALL_ETH_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'4', L'0', L';'};
static wchar_t* SMALL_ETH_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_ETH_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_ETH_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small n tilde numeric character reference xml model. */
static wchar_t SMALL_N_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'4', L'1', L';'};
static wchar_t* SMALL_N_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_N_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_N_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small o grave accent numeric character reference xml model. */
static wchar_t SMALL_O_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'4', L'2', L';'};
static wchar_t* SMALL_O_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_O_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_O_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small o acute accent numeric character reference xml model. */
static wchar_t SMALL_O_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'4', L'3', L';'};
static wchar_t* SMALL_O_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_O_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_O_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small o circumflex accent numeric character reference xml model. */
static wchar_t SMALL_O_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'4', L'4', L';'};
static wchar_t* SMALL_O_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_O_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_O_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small o tilde numeric character reference xml model. */
static wchar_t SMALL_O_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'4', L'5', L';'};
static wchar_t* SMALL_O_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_O_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_O_TILDE_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small o umlaut mark (dieresis) numeric character reference xml model. */
static wchar_t SMALL_O_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'4', L'6', L';'};
static wchar_t* SMALL_O_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_O_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_O_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The division sign numeric character reference xml model. */
static wchar_t DIVISION_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'4', L'7', L';'};
static wchar_t* DIVISION_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = DIVISION_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* DIVISION_SIGN_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small o slash numeric character reference xml model. */
static wchar_t SMALL_O_SLASH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'4', L'8', L';'};
static wchar_t* SMALL_O_SLASH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_O_SLASH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_O_SLASH_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small u grave accent numeric character reference xml model. */
static wchar_t SMALL_U_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'4', L'9', L';'};
static wchar_t* SMALL_U_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_U_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_U_GRAVE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small u acute accent numeric character reference xml model. */
static wchar_t SMALL_U_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'5', L'0', L';'};
static wchar_t* SMALL_U_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_U_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_U_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small u circumflex accent numeric character reference xml model. */
static wchar_t SMALL_U_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'5', L'1', L';'};
static wchar_t* SMALL_U_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_U_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_U_CIRCUMFLEX_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small u umlaut mark (dieresis) numeric character reference xml model. */
static wchar_t SMALL_U_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'5', L'2', L';'};
static wchar_t* SMALL_U_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_U_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_U_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small y acute accent numeric character reference xml model. */
static wchar_t SMALL_Y_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'5', L'3', L';'};
static wchar_t* SMALL_Y_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_Y_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_Y_ACUTE_ACCENT_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small thorn icelandic numeric character reference xml model. */
static wchar_t SMALL_THORN_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'5', L'4', L';'};
static wchar_t* SMALL_THORN_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_THORN_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_THORN_ICELANDIC_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The small y umlaut mark (dieresis) numeric character reference xml model. */
static wchar_t SMALL_Y_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY[] = {L'&', L'#', L'2', L'5', L'5', L';'};
static wchar_t* SMALL_Y_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL = SMALL_Y_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_ARRAY;
static int* SMALL_Y_UMLAUT_MARK_NUMERIC_CHARACTER_REFERENCE_XML_MODEL_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/* NUMERIC_CHARACTER_REFERENCE_XML_MODEL_SOURCE */
#endif
