/*
 * Copyright (C) 1999-2011. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version $RCSfile: addition_arithmetic_operation_cybol_name.c,v $ $Revision: 1.5 $ $Date: 2009-01-31 16:06:30 $ $Author: christian $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_SOURCE
#define ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_SOURCE

#include <stddef.h>
#include "../../../../../constant/model/memory/integer_memory_model.c"

/** The abstraction addition arithmetic operation cybol name. */
static wchar_t ABSTRACTION_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_ARRAY[] = {L'a', L'b', L's', L't', L'r', L'a', L'c', L't', L'i', L'o', L'n'};
static wchar_t* ABSTRACTION_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME = ABSTRACTION_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_ARRAY;
static int* ABSTRACTION_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_MEMORY_MODEL_ARRAY;

/** The summand 1 addition arithmetic operation cybol name. */
static wchar_t SUMMAND_1_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_ARRAY[] = {L's', L'u', L'm', L'm', L'a', L'n', L'd', L'_', L'1'};
static wchar_t* SUMMAND_1_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME = SUMMAND_1_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_ARRAY;
static int* SUMMAND_1_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_MEMORY_MODEL_ARRAY;

/** The summand 2 addition arithmetic operation cybol name. */
static wchar_t SUMMAND_2_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_ARRAY[] = {L's', L'u', L'm', L'm', L'a', L'n', L'd', L'_', L'2'};
static wchar_t* SUMMAND_2_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME = SUMMAND_2_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_ARRAY;
static int* SUMMAND_2_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_MEMORY_MODEL_ARRAY;

/** The sum addition arithmetic operation cybol name. */
static wchar_t SUM_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_ARRAY[] = {L's', L'u', L'm'};
static wchar_t* SUM_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME = SUM_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_ARRAY;
static int* SUM_ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_COUNT = NUMBER_3_INTEGER_MEMORY_MODEL_ARRAY;

/* ADDITION_ARITHMETIC_OPERATION_CYBOL_NAME_SOURCE */
#endif
