/*
 * Copyright (C) 1999-2011. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version $RCSfile: boolean_operation_cybol_name.c,v $ $Revision: 1.4 $ $Date: 2009-01-31 16:06:30 $ $Author: christian $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef BOOLEAN_OPERATION_CYBOL_NAME_SOURCE
#define BOOLEAN_OPERATION_CYBOL_NAME_SOURCE

#include <stddef.h>
#include "../../../../constant/model/memory/integer_memory_model.c"

/** The input 1 boolean operation cybol name. */
static wchar_t INPUT_1_BOOLEAN_OPERATION_CYBOL_NAME_ARRAY[] = {L'i', L'n', L'p', L'u', L't', L'_', L'1'};
static wchar_t* INPUT_1_BOOLEAN_OPERATION_CYBOL_NAME = INPUT_1_BOOLEAN_OPERATION_CYBOL_NAME_ARRAY;
static int* INPUT_1_BOOLEAN_OPERATION_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_MEMORY_MODEL_ARRAY;

/** The input 2 boolean operation cybol name. */
static wchar_t INPUT_2_BOOLEAN_OPERATION_CYBOL_NAME_ARRAY[] = {L'i', L'n', L'p', L'u', L't', L'_', L'2'};
static wchar_t* INPUT_2_BOOLEAN_OPERATION_CYBOL_NAME = INPUT_2_BOOLEAN_OPERATION_CYBOL_NAME_ARRAY;
static int* INPUT_2_BOOLEAN_OPERATION_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_MEMORY_MODEL_ARRAY;

/** The output boolean operation cybol name. */
static wchar_t OUTPUT_BOOLEAN_OPERATION_CYBOL_NAME_ARRAY[] = {L'o', L'u', L't', L'p', L'u', L't'};
static wchar_t* OUTPUT_BOOLEAN_OPERATION_CYBOL_NAME = OUTPUT_BOOLEAN_OPERATION_CYBOL_NAME_ARRAY;
static int* OUTPUT_BOOLEAN_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/* BOOLEAN_OPERATION_CYBOL_NAME_SOURCE */
#endif
