/*
 * Copyright (C) 1999-2011. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version $RCSfile: sense_communication_operation_cybol_name.c,v $ $Revision: 1.6 $ $Date: 2009-01-31 16:06:30 $ $Author: christian $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_SOURCE
#define SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_SOURCE

#include <stddef.h>
#include "../../../../../constant/model/memory/integer_memory_model.c"

/** The channel sense communication operation cybol name. */
static wchar_t CHANNEL_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'c', L'h', L'a', L'n', L'n', L'e', L'l'};
static wchar_t* CHANNEL_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME = CHANNEL_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* CHANNEL_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_MEMORY_MODEL_ARRAY;

/** The handler sense communication operation cybol name. */
static wchar_t HANDLER_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'h', L'a', L'n', L'd', L'l', L'e', L'r'};
static wchar_t* HANDLER_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME = HANDLER_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* HANDLER_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_MEMORY_MODEL_ARRAY;

/** The method sense communication operation cybol name. */
/*??
static wchar_t METHOD_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'm', L'e', L't', L'h', L'o', L'd'};
static wchar_t* METHOD_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME = METHOD_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* METHOD_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The scheme sense communication operation cybol name. */
/*??
static wchar_t SCHEME_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L's', L'c', L'h', L'e', L'm', L'e'};
static wchar_t* SCHEME_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME = SCHEME_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* SCHEME_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The authority sense communication operation cybol name. */
/*??
static wchar_t AUTHORITY_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'a', L'u', L't', L'h', L'o', L'r', L'i', L't', L'y'};
static wchar_t* AUTHORITY_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME = AUTHORITY_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* AUTHORITY_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_MEMORY_MODEL_ARRAY;

/** The path sense communication operation cybol name. */
/*??
static wchar_t PATH_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'p', L'a', L't', L'h'};
static wchar_t* PATH_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME = PATH_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* PATH_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_MEMORY_MODEL_ARRAY;

/** The fragment sense communication operation cybol name. */
/*??
static wchar_t FRAGMENT_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'f', L'r', L'a', L'g', L'm', L'e', L'n', L't'};
static wchar_t* FRAGMENT_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME = FRAGMENT_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* FRAGMENT_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_MEMORY_MODEL_ARRAY;

/** The action sense communication operation cybol name. */
/*??
static wchar_t ACTION_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'a', L'c', L't', L'i', L'o', L'n'};
static wchar_t* ACTION_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME = ACTION_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* ACTION_SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/* SENSE_COMMUNICATION_OPERATION_CYBOL_NAME_SOURCE */
#endif
