/*
 * Copyright (C) 1999-2011. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version $RCSfile: count_memory_operation_cybol_name.c,v $ $Revision: 1.3 $ $Date: 2009-01-31 16:06:30 $ $Author: christian $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef COUNT_FLOW_OPERATION_CYBOL_NAME_SOURCE
#define COUNT_FLOW_OPERATION_CYBOL_NAME_SOURCE

#include <stddef.h>
#include "../../../../../constant/model/memory/integer_memory_model.c"

/** The compound count flow operation cybol name. */
static wchar_t COMPOUND_MEMORY_MODEL_COUNT_FLOW_OPERATION_CYBOL_NAME_ARRAY[] = {L'c', L'o', L'm', L'p', L'o', L'u', L'n', L'd'};
static wchar_t* COMPOUND_MEMORY_MODEL_COUNT_FLOW_OPERATION_CYBOL_NAME = COMPOUND_MEMORY_MODEL_COUNT_FLOW_OPERATION_CYBOL_NAME_ARRAY;
static int* COMPOUND_MEMORY_MODEL_COUNT_FLOW_OPERATION_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_MEMORY_MODEL_ARRAY;

/** The selection count flow operation cybol name. */
static wchar_t SELECTION_COUNT_FLOW_OPERATION_CYBOL_NAME_ARRAY[] = {L's', L'e', L'l', L'e', L'c', L't', L'i', L'o', L'n'};
static wchar_t* SELECTION_COUNT_FLOW_OPERATION_CYBOL_NAME = SELECTION_COUNT_FLOW_OPERATION_CYBOL_NAME_ARRAY;
static int* SELECTION_COUNT_FLOW_OPERATION_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_MEMORY_MODEL_ARRAY;

/** The filter count flow operation cybol name. */
static wchar_t FILTER_COUNT_FLOW_OPERATION_CYBOL_NAME_ARRAY[] = {L'f', L'i', L'l', L't', L'e', L'r'};
static wchar_t* FILTER_COUNT_FLOW_OPERATION_CYBOL_NAME = FILTER_COUNT_FLOW_OPERATION_CYBOL_NAME_ARRAY;
static int* FILTER_COUNT_FLOW_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/** The result count flow operation cybol name. */
static wchar_t RESULT_COUNT_FLOW_OPERATION_CYBOL_NAME_ARRAY[] = {L'r', L'e', L's', L'u', L'l', L't'};
static wchar_t* RESULT_COUNT_FLOW_OPERATION_CYBOL_NAME = RESULT_COUNT_FLOW_OPERATION_CYBOL_NAME_ARRAY;
static int* RESULT_COUNT_FLOW_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_MEMORY_MODEL_ARRAY;

/* COUNT_FLOW_OPERATION_CYBOL_NAME_SOURCE */
#endif
