/*
 * Copyright (C) 1999-2011. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version $RCSfile: http_request_processor.c,v $ $Revision: 1.6 $ $Date: 2009-10-06 21:25:27 $ $Author: christian $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef HEADER_ENTRY_HTTP_RESPONSE_ENCODER_SOURCE
#define HEADER_ENTRY_HTTP_RESPONSE_ENCODER_SOURCE

#include "../../../../constant/model/log/message_log_model.c"
#include "../../../../constant/model/memory/integer_memory_model.c"
#include "../../../../constant/model/memory/pointer_memory_model.c"
#include "../../../../constant/name/http/cyboi_http_name.c"
#include "../../../../executor/accessor/appender/part_appender.c"
#include "../../../../executor/converter/selector/http_response/header_entry_http_response_selector.c"
#include "../../../../executor/memoriser/allocator/model_allocator.c"
#include "../../../../executor/memoriser/deallocator/model_deallocator.c"
#include "../../../../logger/logger.c"

/**
 * Encodes the http response header entry.
 *
 * @param p0 the destination character array (Hand over as reference!)
 * @param p1 the destination character array count
 * @param p2 the destination character array size
 * @param p3 the source metadata model
 * @param p4 the source metadata model count
 * @param p5 the source metadata model index
 * @param p6 the source message model count
 */
void encode_http_response_header_entry(void* p0, void* p1, void* p2, void* p3, void* p4, void* p5, void* p6) {

    log_terminated_message((void*) DEBUG_LEVEL_LOG_MODEL, (void*) L"Encode http response header entry.");

    // The source part details name, abstraction, model, details.
    void** n = NULL_POINTER_MEMORY_MODEL;
    void** nc = NULL_POINTER_MEMORY_MODEL;
    void** ns = NULL_POINTER_MEMORY_MODEL;
    void** a = NULL_POINTER_MEMORY_MODEL;
    void** ac = NULL_POINTER_MEMORY_MODEL;
    void** as = NULL_POINTER_MEMORY_MODEL;
    void** m = NULL_POINTER_MEMORY_MODEL;
    void** mc = NULL_POINTER_MEMORY_MODEL;
    void** ms = NULL_POINTER_MEMORY_MODEL;
    void** d = NULL_POINTER_MEMORY_MODEL;
    void** dc = NULL_POINTER_MEMORY_MODEL;
    void** ds = NULL_POINTER_MEMORY_MODEL;

//??    fwprintf(stdout, L"TEST encode http response header entry p6: %i\n", *((int*) p6));

    // Get source part at index.
    get_compound_element_by_index(p3, p4, p5,
        (void*) &n, (void*) &nc, (void*) &ns,
        (void*) &a, (void*) &ac, (void*) &as,
        (void*) &m, (void*) &mc, (void*) &ms,
        (void*) &d, (void*) &dc, (void*) &ds);

/*??
    fwprintf(stdout, L"TEST encode http response header entry nc: %i\n", *nc);
    fwprintf(stdout, L"TEST encode http response header entry n: %i\n", *n);
    fwprintf(stdout, L"TEST encode http response header entry n: %ls\n", (wchar_t*) *n);
    fwprintf(stdout, L"TEST encode http response header entry ac: %i\n", *ac);
    fwprintf(stdout, L"TEST encode http response header entry a: %i\n", *a);
    fwprintf(stdout, L"TEST encode http response header entry a: %ls\n", (wchar_t*) *a);
    fwprintf(stdout, L"TEST encode http response header entry mc: %i\n", *mc);
    fwprintf(stdout, L"TEST encode http response header entry m: %i\n", *m);
    fwprintf(stdout, L"TEST encode http response header entry m: %ls\n", (wchar_t*) *m);
    fwprintf(stdout, L"TEST encode http response header entry dc: %i\n", *dc);
    fwprintf(stdout, L"TEST encode http response header entry d: %i\n", *d);
*/

    select_http_response_header_entry(p0, p1, p2, *n, *nc, *a, *ac, *m, *mc, *d, *dc, p6);
}

/* HEADER_ENTRY_HTTP_RESPONSE_ENCODER_SOURCE */
#endif
