/*
 * Copyright (C) 1999-2012. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.12.0 2012-08-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE
#define DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The destination deserialise representation operation cybol name. */
static wchar_t DESTINATION_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'd', L'e', L's', L't', L'i', L'n', L'a', L't', L'i', L'o', L'n'};
static wchar_t* DESTINATION_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME = DESTINATION_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_ARRAY;
static int* DESTINATION_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source deserialise representation operation cybol name. */
static wchar_t SOURCE_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_ARRAY[] = {L's', L'o', L'u', L'r', L'c', L'e'};
static wchar_t* SOURCE_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME = SOURCE_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_ARRAY;
static int* SOURCE_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The format deserialise representation operation cybol name. */
static wchar_t FORMAT_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'f', L'o', L'r', L'm', L'a', L't'};
static wchar_t* FORMAT_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME = FORMAT_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_ARRAY;
static int* FORMAT_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The language deserialise representation operation cybol name. */
static wchar_t LANGUAGE_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'l', L'a', L'n', L'g', L'u', L'a', L'g', L'e'};
static wchar_t* LANGUAGE_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME = LANGUAGE_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_ARRAY;
static int* LANGUAGE_DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* DESERIALISE_REPRESENTATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE */
#endif
