/*
 * Copyright (C) 1999-2012. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.12.0 2012-08-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef TAG_WEB_USER_INTERFACE_CYBOL_NAME_CONSTANT_SOURCE
#define TAG_WEB_USER_INTERFACE_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The tag web user interface cybol name. */
static wchar_t TAG_WEB_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L't', L'a', L'g'};
static wchar_t* TAG_WEB_USER_INTERFACE_CYBOL_NAME = TAG_WEB_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* TAG_WEB_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The preformatted web user interface cybol name. */
static wchar_t PREFORMATTED_WEB_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'p', L'r', L'e', L'f', L'o', L'r', L'm', L'a', L't', L't', L'e', L'd'};
static wchar_t* PREFORMATTED_WEB_USER_INTERFACE_CYBOL_NAME = PREFORMATTED_WEB_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* PREFORMATTED_WEB_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The property web user interface cybol name. */
static wchar_t PROPERTY_WEB_USER_INTERFACE_CYBOL_NAME_ARRAY[] = {L'p', L'r', L'o', L'p', L'e', L'r', L't', L'y'};
static wchar_t* PROPERTY_WEB_USER_INTERFACE_CYBOL_NAME = PROPERTY_WEB_USER_INTERFACE_CYBOL_NAME_ARRAY;
static int* PROPERTY_WEB_USER_INTERFACE_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* TAG_WEB_USER_INTERFACE_CYBOL_NAME_CONSTANT_SOURCE */
#endif
