/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.13.0 2013-03-29
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef COPY_FILE_OPERATION_CYBOL_NAME_CONSTANT_SOURCE
#define COPY_FILE_OPERATION_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The destination copy file operation cybol name. */
static wchar_t DESTINATION_COPY_FILE_OPERATION_CYBOL_NAME_ARRAY[] = {L'd', L'e', L's', L't', L'i', L'n', L'a', L't', L'i', L'o', L'n'};
static wchar_t* DESTINATION_COPY_FILE_OPERATION_CYBOL_NAME = DESTINATION_COPY_FILE_OPERATION_CYBOL_NAME_ARRAY;
static int* DESTINATION_COPY_FILE_OPERATION_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The recursive copy file operation cybol name. */
static wchar_t RECURSIVE_COPY_FILE_OPERATION_CYBOL_NAME_ARRAY[] = {L'r', L'e', L'c', L'u', L'r', L's', L'i', L'v', L'e'};
static wchar_t* RECURSIVE_COPY_FILE_OPERATION_CYBOL_NAME = RECURSIVE_COPY_FILE_OPERATION_CYBOL_NAME_ARRAY;
static int* RECURSIVE_COPY_FILE_OPERATION_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source copy file operation cybol name. */
static wchar_t SOURCE_COPY_FILE_OPERATION_CYBOL_NAME_ARRAY[] = {L's', L'o', L'u', L'r', L'c', L'e'};
static wchar_t* SOURCE_COPY_FILE_OPERATION_CYBOL_NAME = SOURCE_COPY_FILE_OPERATION_CYBOL_NAME_ARRAY;
static int* SOURCE_COPY_FILE_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* COPY_FILE_OPERATION_CYBOL_NAME_CONSTANT_SOURCE */
#endif
