/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.13.0 2013-03-29
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef FILL_MODIFICATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE
#define FILL_MODIFICATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The part fill modification operation cybol name. */
static wchar_t PART_FILL_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'p', L'a', L'r', L't'};
static wchar_t* PART_FILL_MODIFICATION_OPERATION_CYBOL_NAME = PART_FILL_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* PART_FILL_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The element fill modification operation cybol name. */
static wchar_t ELEMENT_FILL_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'e', L'l', L'e', L'm', L'e', L'n', L't'};
static wchar_t* ELEMENT_FILL_MODIFICATION_OPERATION_CYBOL_NAME = ELEMENT_FILL_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* ELEMENT_FILL_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The count fill modification operation cybol name. */
static wchar_t COUNT_FILL_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'c', L'o', L'u', L'n', L't'};
static wchar_t* COUNT_FILL_MODIFICATION_OPERATION_CYBOL_NAME = COUNT_FILL_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* COUNT_FILL_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The index fill modification operation cybol name. */
static wchar_t INDEX_FILL_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'i', L'n', L'd', L'e', L'x'};
static wchar_t* INDEX_FILL_MODIFICATION_OPERATION_CYBOL_NAME = INDEX_FILL_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* INDEX_FILL_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The adjust fill modification operation cybol name. */
static wchar_t ADJUST_FILL_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'a', L'd', L'j', L'u', L's', L't'};
static wchar_t* ADJUST_FILL_MODIFICATION_OPERATION_CYBOL_NAME = ADJUST_FILL_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* ADJUST_FILL_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* FILL_MODIFICATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE */
#endif
