/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.13.0 2013-03-29
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef INSERT_MODIFICATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE
#define INSERT_MODIFICATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The destination insert modification operation cybol name. */
static wchar_t DESTINATION_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'd', L'e', L's', L't', L'i', L'n', L'a', L't', L'i', L'o', L'n'};
static wchar_t* DESTINATION_INSERT_MODIFICATION_OPERATION_CYBOL_NAME = DESTINATION_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* DESTINATION_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source insert modification operation cybol name. */
static wchar_t SOURCE_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L's', L'o', L'u', L'r', L'c', L'e'};
static wchar_t* SOURCE_INSERT_MODIFICATION_OPERATION_CYBOL_NAME = SOURCE_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* SOURCE_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The type insert modification operation cybol name. */
static wchar_t TYPE_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L't', L'y', L'p', L'e'};
static wchar_t* TYPE_INSERT_MODIFICATION_OPERATION_CYBOL_NAME = TYPE_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* TYPE_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The count insert modification operation cybol name. */
static wchar_t COUNT_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'c', L'o', L'u', L'n', L't'};
static wchar_t* COUNT_INSERT_MODIFICATION_OPERATION_CYBOL_NAME = COUNT_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* COUNT_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The destination_index insert modification operation cybol name. */
static wchar_t DESTINATION_INDEX_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L'd', L'e', L's', L't', L'i', L'n', L'a', L't', L'i', L'o', L'n', L'_', L'i', L'n', L'd', L'e', L'x'};
static wchar_t* DESTINATION_INDEX_INSERT_MODIFICATION_OPERATION_CYBOL_NAME = DESTINATION_INDEX_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* DESTINATION_INDEX_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_17_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source_index insert modification operation cybol name. */
static wchar_t SOURCE_INDEX_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY[] = {L's', L'o', L'u', L'r', L'c', L'e', L'_', L'i', L'n', L'd', L'e', L'x'};
static wchar_t* SOURCE_INDEX_INSERT_MODIFICATION_OPERATION_CYBOL_NAME = SOURCE_INDEX_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_ARRAY;
static int* SOURCE_INDEX_INSERT_MODIFICATION_OPERATION_CYBOL_NAME_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* INSERT_MODIFICATION_OPERATION_CYBOL_NAME_CONSTANT_SOURCE */
#endif
