/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.14.0 2013-05-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef ISO_8859_11_CHARACTER_CODE_MODEL_CONSTANT_SOURCE
#define ISO_8859_11_CHARACTER_CODE_MODEL_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../constant/model/character_code/ascii/ascii_character_code_model.c"

//
// A "Character Set" consists of three parts:
// - Character Repertoire: a, b, c etc., e.g. ISO 8859-1 with 256 characters and Unicode with ~ 1 Mio. characters
// - Character Code: table assigning numbers, e.g. a = 97, b = 98, c = 99 etc.
// - Character Encoding: storing code numbers in Bytes, e.g. 97 = 01100001, 98 = 01100010, 99 = 01100011 etc.
//

//
// ISO/IEC 8859 is a joint ISO and IEC series of standards for 8-bit character encodings.
// The series of standards consists of numbered parts, such as ISO/IEC 8859-1, ISO/IEC 8859-2, etc.
// There are 15 parts, excluding the abandoned ISO/IEC 8859-12.
// The ISO working group maintaining this series of standards has been disbanded.
// ISO/IEC 8859 parts 1, 2, 3, and 4 were originally Ecma International standard ECMA-94.
//
// While "ISO/IEC 8859" (without hyphen) does NOT define
// any characters for ranges 0x00-0x1F and 0x7F-0x9F,
// the "ISO-8859" (WITH hyphen and WITHOUT "IEC") standard
// registered with the IANA specifies non-printable
// control characters within these FREE areas.
// Therefore, both are related and do NOT conflict.
//
// CAUTION! The "ISO/IEC 8859-11" did NOT get assigned an
// IANA charset "ISO-8859-11", presumably because it was
// almost identical to the Thai Industrial Standard (TIS) 620.
//
// This file contains ISO/IEC 8859-11 character code constants:
// Latin/Thai
//

//
// The ascii characters in range 0x00-0x7F are NOT repeated here
//

//
// The non-printable control characters in range 0x80-0x9F
// are NOT defined, since an "ISO-8859-11" does NOT exist.
//

//
// The printable characters in range 0xA0-0xFF
//

/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xA1    0x0E01  #       THAI CHARACTER KO KAI
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xA2    0x0E02  #       THAI CHARACTER KHO KHAI
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xA3    0x0E03  #       THAI CHARACTER KHO KHUAT
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xA4    0x0E04  #       THAI CHARACTER KHO KHWAI
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xA5    0x0E05  #       THAI CHARACTER KHO KHON
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xA6    0x0E06  #       THAI CHARACTER KHO RAKHANG
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xA7    0x0E07  #       THAI CHARACTER NGO NGU
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xA8    0x0E08  #       THAI CHARACTER CHO CHAN
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xA9    0x0E09  #       THAI CHARACTER CHO CHING
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xAA    0x0E0A  #       THAI CHARACTER CHO CHANG
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xAB    0x0E0B  #       THAI CHARACTER SO SO
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xAC    0x0E0C  #       THAI CHARACTER CHO CHOE
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xAD    0x0E0D  #       THAI CHARACTER YO YING
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xAE    0x0E0E  #       THAI CHARACTER DO CHADA
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xAF    0x0E0F  #       THAI CHARACTER TO PATAK
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xB0    0x0E10  #       THAI CHARACTER THO THAN
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xB1    0x0E11  #       THAI CHARACTER THO NANGMONTHO
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xB2    0x0E12  #       THAI CHARACTER THO PHUTHAO
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xB3    0x0E13  #       THAI CHARACTER NO NEN
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xB4    0x0E14  #       THAI CHARACTER DO DEK
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xB5    0x0E15  #       THAI CHARACTER TO TAO
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xB6    0x0E16  #       THAI CHARACTER THO THUNG
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xB7    0x0E17  #       THAI CHARACTER THO THAHAN
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xB8    0x0E18  #       THAI CHARACTER THO THONG
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xB9    0x0E19  #       THAI CHARACTER NO NU
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xBA    0x0E1A  #       THAI CHARACTER BO BAIMAI
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xBB    0x0E1B  #       THAI CHARACTER PO PLA
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xBC    0x0E1C  #       THAI CHARACTER PHO PHUNG
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xBD    0x0E1D  #       THAI CHARACTER FO FA
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xBE    0x0E1E  #       THAI CHARACTER PHO PHAN
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xBF    0x0E1F  #       THAI CHARACTER FO FAN
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xC0    0x0E20  #       THAI CHARACTER PHO SAMPHAO
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xC1    0x0E21  #       THAI CHARACTER MO MA
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xC2    0x0E22  #       THAI CHARACTER YO YAK
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xC3    0x0E23  #       THAI CHARACTER RO RUA
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xC4    0x0E24  #       THAI CHARACTER RU
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xC5    0x0E25  #       THAI CHARACTER LO LING
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xC6    0x0E26  #       THAI CHARACTER LU
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xC7    0x0E27  #       THAI CHARACTER WO WAEN
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xC8    0x0E28  #       THAI CHARACTER SO SALA
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xC9    0x0E29  #       THAI CHARACTER SO RUSI
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xCA    0x0E2A  #       THAI CHARACTER SO SUA
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xCB    0x0E2B  #       THAI CHARACTER HO HIP
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xCC    0x0E2C  #       THAI CHARACTER LO CHULA
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xCD    0x0E2D  #       THAI CHARACTER O ANG
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xCE    0x0E2E  #       THAI CHARACTER HO NOKHUK
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xCF    0x0E2F  #       THAI CHARACTER PAIYANNOI
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xD0    0x0E30  #       THAI CHARACTER SARA A
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xD1    0x0E31  #       THAI CHARACTER MAI HAN-AKAT
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xD2    0x0E32  #       THAI CHARACTER SARA AA
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xD3    0x0E33  #       THAI CHARACTER SARA AM
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xD4    0x0E34  #       THAI CHARACTER SARA I
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xD5    0x0E35  #       THAI CHARACTER SARA II
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xD6    0x0E36  #       THAI CHARACTER SARA UE
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xD7    0x0E37  #       THAI CHARACTER SARA UEE
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xD8    0x0E38  #       THAI CHARACTER SARA U
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xD9    0x0E39  #       THAI CHARACTER SARA UU
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xDA    0x0E3A  #       THAI CHARACTER PHINTHU
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xDF    0x0E3F  #       THAI CURRENCY SYMBOL BAHT
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xE0    0x0E40  #       THAI CHARACTER SARA E
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xE1    0x0E41  #       THAI CHARACTER SARA AE
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xE2    0x0E42  #       THAI CHARACTER SARA O
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xE3    0x0E43  #       THAI CHARACTER SARA AI MAIMUAN
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xE4    0x0E44  #       THAI CHARACTER SARA AI MAIMALAI
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xE5    0x0E45  #       THAI CHARACTER LAKKHANGYAO
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xE6    0x0E46  #       THAI CHARACTER MAIYAMOK
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xE7    0x0E47  #       THAI CHARACTER MAITAIKHU
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xE8    0x0E48  #       THAI CHARACTER MAI EK
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xE9    0x0E49  #       THAI CHARACTER MAI THO
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xEA    0x0E4A  #       THAI CHARACTER MAI TRI
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xEB    0x0E4B  #       THAI CHARACTER MAI CHATTAWA
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xEC    0x0E4C  #       THAI CHARACTER THANTHAKHAT
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xED    0x0E4D  #       THAI CHARACTER NIKHAHIT
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xEE    0x0E4E  #       THAI CHARACTER YAMAKKAN
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xEF    0x0E4F  #       THAI CHARACTER FONGMAN
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xF0    0x0E50  #       THAI DIGIT ZERO
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xF1    0x0E51  #       THAI DIGIT ONE
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xF2    0x0E52  #       THAI DIGIT TWO
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xF3    0x0E53  #       THAI DIGIT THREE
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xF4    0x0E54  #       THAI DIGIT FOUR
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xF5    0x0E55  #       THAI DIGIT FIVE
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xF6    0x0E56  #       THAI DIGIT SIX
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xF7    0x0E57  #       THAI DIGIT SEVEN
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xF8    0x0E58  #       THAI DIGIT EIGHT
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xF9    0x0E59  #       THAI DIGIT NINE
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xFA    0x0E5A  #       THAI CHARACTER ANGKHANKHU
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

0xFB    0x0E5B  #       THAI CHARACTER KHOMUT
/** The no-break space iso-8859-11 character code model. U+00A0 */
static unsigned char NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY[] = {0xA0};
static unsigned char* NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL = NO_BREAK_SPACE_ISO_8859_11_CHARACTER_CODE_MODEL_ARRAY;

/* ISO_8859_11_CHARACTER_CODE_MODEL_CONSTANT_SOURCE */
#endif
