/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.14.0 2013-05-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The channel receive communication logic cybol name. */
static wchar_t CHANNEL_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'c', L'h', L'a', L'n', L'n', L'e', L'l'};
static wchar_t* CHANNEL_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME = CHANNEL_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* CHANNEL_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The encoding receive communication logic cybol name. */
static wchar_t ENCODING_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'e', L'n', L'c', L'o', L'd', L'i', L'n', L'g'};
static wchar_t* ENCODING_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME = ENCODING_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* ENCODING_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The language receive communication logic cybol name. */
static wchar_t LANGUAGE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'a', L'n', L'g', L'u', L'a', L'g', L'e'};
static wchar_t* LANGUAGE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME = LANGUAGE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* LANGUAGE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The format receive communication logic cybol name. */
static wchar_t FORMAT_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'f', L'o', L'r', L'm', L'a', L't'};
static wchar_t* FORMAT_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME = FORMAT_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* FORMAT_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The message receive communication logic cybol name. */
static wchar_t MESSAGE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'm', L'e', L's', L's', L'a', L'g', L'e'};
static wchar_t* MESSAGE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME = MESSAGE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* MESSAGE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The meta receive communication logic cybol name. */
static wchar_t META_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'm', L'e', L't', L'a'};
static wchar_t* META_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME = META_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* META_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The model receive communication logic cybol name. */
static wchar_t MODEL_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'm', L'o', L'd', L'e', L'l'};
static wchar_t* MODEL_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME = MODEL_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* MODEL_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The minimum receive communication logic cybol name. */
static wchar_t MINIMUM_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'm', L'i', L'n', L'i', L'm', L'u', L'm'};
static wchar_t* MINIMUM_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME = MINIMUM_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* MINIMUM_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The maximum receive communication logic cybol name. */
static wchar_t MAXIMUM_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'm', L'a', L'x', L'i', L'm', L'u', L'm'};
static wchar_t* MAXIMUM_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME = MAXIMUM_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* MAXIMUM_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The root receive communication logic cybol name. */
static wchar_t ROOT_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'r', L'o', L'o', L't'};
static wchar_t* ROOT_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME = ROOT_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* ROOT_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The style receive communication logic cybol name. */
static wchar_t STYLE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L't', L'y', L'l', L'e'};
static wchar_t* STYLE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME = STYLE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* STYLE_RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* RECEIVE_COMMUNICATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
