/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.14.0 2013-05-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef LOGIC_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define LOGIC_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The input 1 logic logic cybol name. */
static wchar_t INPUT_1_LOGIC_LOGIC_CYBOL_NAME_ARRAY[] = {L'i', L'n', L'p', L'u', L't', L'_', L'1'};
static wchar_t* INPUT_1_LOGIC_LOGIC_CYBOL_NAME = INPUT_1_LOGIC_LOGIC_CYBOL_NAME_ARRAY;
static int* INPUT_1_LOGIC_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The input 2 logic logic cybol name. */
static wchar_t INPUT_2_LOGIC_LOGIC_CYBOL_NAME_ARRAY[] = {L'i', L'n', L'p', L'u', L't', L'_', L'2'};
static wchar_t* INPUT_2_LOGIC_LOGIC_CYBOL_NAME = INPUT_2_LOGIC_LOGIC_CYBOL_NAME_ARRAY;
static int* INPUT_2_LOGIC_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The output logic logic cybol name. */
static wchar_t OUTPUT_LOGIC_LOGIC_CYBOL_NAME_ARRAY[] = {L'o', L'u', L't', L'p', L'u', L't'};
static wchar_t* OUTPUT_LOGIC_LOGIC_CYBOL_NAME = OUTPUT_LOGIC_LOGIC_CYBOL_NAME_ARRAY;
static int* OUTPUT_LOGIC_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* LOGIC_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
