/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * Christian Heller <christian.heller@tuxtax.de>
 *
 * @version CYBOP 0.14.0 2013-05-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef HTTP_REQUEST_SERIALISER_SOURCE
#define HTTP_REQUEST_SERIALISER_SOURCE

#include "../../../../constant/model/cyboi/log/message_log_cyboi_model.c"
#include "../../../../logger/logger.c"

//
// Since http is a stateless protocol, it does not provide a possibility to
// find out whether or not several consequent http requests belong together.
//
// Therefore, the application on the next higher level of type has to
// care about that, by opening a "session" for each request from an unknown user.
// Every such session gets a unique identifier called "session id".
//
// Whenever the client now sends an http request to the server,
// it also sends the session id, so that data already stored on the
// server can be assigned to the correct user.
//
// There are several ways to transfer a session id:
// 1 as cookie
// 2 within the uri
// 2.1 GET
// 2.1.1 in the query, e.g.:
// http://domain.tld/index.php?sid=3Dedb0e8665db4e9042fe0176a89aade16
// 2.1.2 in the path
// http://domain.tld/edb0e8665db4e9042fe0176a89aade16/index.php
// 2.2 POST (within html forms, using input elements of type ?hidden")
//
// Problems:
// 1 Many users have cookies deactivated in their browsers.
//   However, an application may request to activate cookies.
// 2 Each uri of a (generated) webpage has to be modified to contain the session id.
// 2.2 All navigation has to occur via html forms (buttons etc.); simple links do not suffice
//
// In order to avoid users manipulating and using the session id of another user,
// a session id has to be generated from a range of values that is large enough
// to minimise the probability of guessing another user's session id.
//

/**
 * Serialises the source into an http request.
 *
 * @param p0 the destination item
 * @param p1 the source model data
 * @param p2 the source model count
 * @param p3 the source properties data
 * @param p4 the source properties count
 */
void serialise_http_request(void* p0, void* p1, void* p2, void* p3, void* p4) {

    log_message_terminated((void*) INFORMATION_LEVEL_LOG_CYBOI_MODEL, (void*) L"Serialise http request.");
}

/* HTTP_REQUEST_SERIALISER_SOURCE */
#endif
